// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The elastic pool edition capability.
 */
@Fluent
public final class ElasticPoolEditionCapability implements JsonSerializable<ElasticPoolEditionCapability> {
    /*
     * The elastic pool edition name.
     */
    private String name;

    /*
     * The list of supported elastic pool DTU levels for the edition.
     */
    private List<ElasticPoolPerformanceLevelCapability> supportedElasticPoolPerformanceLevels;

    /*
     * Whether or not zone redundancy is supported for the edition.
     */
    private Boolean zoneRedundant;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ElasticPoolEditionCapability class.
     */
    public ElasticPoolEditionCapability() {
    }

    /**
     * Get the name property: The elastic pool edition name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the supportedElasticPoolPerformanceLevels property: The list of supported elastic pool DTU levels for the
     * edition.
     * 
     * @return the supportedElasticPoolPerformanceLevels value.
     */
    public List<ElasticPoolPerformanceLevelCapability> supportedElasticPoolPerformanceLevels() {
        return this.supportedElasticPoolPerformanceLevels;
    }

    /**
     * Get the zoneRedundant property: Whether or not zone redundancy is supported for the edition.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ElasticPoolEditionCapability object itself.
     */
    public ElasticPoolEditionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedElasticPoolPerformanceLevels() != null) {
            supportedElasticPoolPerformanceLevels().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ElasticPoolEditionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ElasticPoolEditionCapability if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ElasticPoolEditionCapability.
     */
    public static ElasticPoolEditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ElasticPoolEditionCapability deserializedElasticPoolEditionCapability = new ElasticPoolEditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedElasticPoolEditionCapability.name = reader.getString();
                } else if ("supportedElasticPoolPerformanceLevels".equals(fieldName)) {
                    List<ElasticPoolPerformanceLevelCapability> supportedElasticPoolPerformanceLevels
                        = reader.readArray(reader1 -> ElasticPoolPerformanceLevelCapability.fromJson(reader1));
                    deserializedElasticPoolEditionCapability.supportedElasticPoolPerformanceLevels
                        = supportedElasticPoolPerformanceLevels;
                } else if ("zoneRedundant".equals(fieldName)) {
                    deserializedElasticPoolEditionCapability.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                } else if ("status".equals(fieldName)) {
                    deserializedElasticPoolEditionCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedElasticPoolEditionCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedElasticPoolEditionCapability;
        });
    }
}
