// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of the managed instance administrator.
 */
public final class ManagedInstanceAdministratorType extends ExpandableStringEnum<ManagedInstanceAdministratorType> {
    /**
     * Static value ActiveDirectory for ManagedInstanceAdministratorType.
     */
    public static final ManagedInstanceAdministratorType ACTIVE_DIRECTORY = fromString("ActiveDirectory");

    /**
     * Creates a new instance of ManagedInstanceAdministratorType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ManagedInstanceAdministratorType() {
    }

    /**
     * Creates or finds a ManagedInstanceAdministratorType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ManagedInstanceAdministratorType.
     */
    public static ManagedInstanceAdministratorType fromString(String name) {
        return fromString(name, ManagedInstanceAdministratorType.class);
    }

    /**
     * Gets known ManagedInstanceAdministratorType values.
     * 
     * @return known ManagedInstanceAdministratorType values.
     */
    public static Collection<ManagedInstanceAdministratorType> values() {
        return values(ManagedInstanceAdministratorType.class);
    }
}
