// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The secondary type of the database if it is a secondary. Valid values are Geo and Named.
 */
public final class SecondaryType extends ExpandableStringEnum<SecondaryType> {
    /**
     * Static value Geo for SecondaryType.
     */
    public static final SecondaryType GEO = fromString("Geo");

    /**
     * Static value Named for SecondaryType.
     */
    public static final SecondaryType NAMED = fromString("Named");

    /**
     * Creates a new instance of SecondaryType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SecondaryType() {
    }

    /**
     * Creates or finds a SecondaryType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SecondaryType.
     */
    public static SecondaryType fromString(String name) {
        return fromString(name, SecondaryType.class);
    }

    /**
     * Gets known SecondaryType values.
     * 
     * @return known SecondaryType values.
     */
    public static Collection<SecondaryType> values() {
        return values(SecondaryType.class);
    }
}
