// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of a short term retention policy.
 */
@Fluent
public final class ManagedBackupShortTermRetentionPolicyProperties
    implements JsonSerializable<ManagedBackupShortTermRetentionPolicyProperties> {
    /*
     * The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     */
    private Integer retentionDays;

    /**
     * Creates an instance of ManagedBackupShortTermRetentionPolicyProperties class.
     */
    public ManagedBackupShortTermRetentionPolicyProperties() {
    }

    /**
     * Get the retentionDays property: The backup retention period in days. This is how many days Point-in-Time Restore
     * will be supported.
     * 
     * @return the retentionDays value.
     */
    public Integer retentionDays() {
        return this.retentionDays;
    }

    /**
     * Set the retentionDays property: The backup retention period in days. This is how many days Point-in-Time Restore
     * will be supported.
     * 
     * @param retentionDays the retentionDays value to set.
     * @return the ManagedBackupShortTermRetentionPolicyProperties object itself.
     */
    public ManagedBackupShortTermRetentionPolicyProperties withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("retentionDays", this.retentionDays);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedBackupShortTermRetentionPolicyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedBackupShortTermRetentionPolicyProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedBackupShortTermRetentionPolicyProperties.
     */
    public static ManagedBackupShortTermRetentionPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedBackupShortTermRetentionPolicyProperties deserializedManagedBackupShortTermRetentionPolicyProperties
                = new ManagedBackupShortTermRetentionPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("retentionDays".equals(fieldName)) {
                    deserializedManagedBackupShortTermRetentionPolicyProperties.retentionDays
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedBackupShortTermRetentionPolicyProperties;
        });
    }
}
