// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ManagedInstancePrivateEndpointProperty;
import com.azure.resourcemanager.sql.models.ManagedInstancePrivateLinkServiceConnectionStateProperty;
import java.io.IOException;

/**
 * A private endpoint connection.
 */
@Fluent
public final class ManagedInstancePrivateEndpointConnectionInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ManagedInstancePrivateEndpointConnectionProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ManagedInstancePrivateEndpointConnectionInner class.
     */
    public ManagedInstancePrivateEndpointConnectionInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ManagedInstancePrivateEndpointConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the privateEndpoint property: Private endpoint which the connection belongs to.
     * 
     * @return the privateEndpoint value.
     */
    public ManagedInstancePrivateEndpointProperty privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    /**
     * Set the privateEndpoint property: Private endpoint which the connection belongs to.
     * 
     * @param privateEndpoint the privateEndpoint value to set.
     * @return the ManagedInstancePrivateEndpointConnectionInner object itself.
     */
    public ManagedInstancePrivateEndpointConnectionInner
        withPrivateEndpoint(ManagedInstancePrivateEndpointProperty privateEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstancePrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    /**
     * Get the privateLinkServiceConnectionState property: Connection State of the Private Endpoint Connection.
     * 
     * @return the privateLinkServiceConnectionState value.
     */
    public ManagedInstancePrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    /**
     * Set the privateLinkServiceConnectionState property: Connection State of the Private Endpoint Connection.
     * 
     * @param privateLinkServiceConnectionState the privateLinkServiceConnectionState value to set.
     * @return the ManagedInstancePrivateEndpointConnectionInner object itself.
     */
    public ManagedInstancePrivateEndpointConnectionInner withPrivateLinkServiceConnectionState(
        ManagedInstancePrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstancePrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    /**
     * Get the provisioningState property: State of the Private Endpoint Connection.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstancePrivateEndpointConnectionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstancePrivateEndpointConnectionInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedInstancePrivateEndpointConnectionInner.
     */
    public static ManagedInstancePrivateEndpointConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstancePrivateEndpointConnectionInner deserializedManagedInstancePrivateEndpointConnectionInner
                = new ManagedInstancePrivateEndpointConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedInstancePrivateEndpointConnectionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedInstancePrivateEndpointConnectionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedInstancePrivateEndpointConnectionInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedInstancePrivateEndpointConnectionInner.innerProperties
                        = ManagedInstancePrivateEndpointConnectionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstancePrivateEndpointConnectionInner;
        });
    }
}
