// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.QueryMetricInterval;
import java.io.IOException;
import java.util.List;

/**
 * The QueryStatistics model.
 */
@Fluent
public final class QueryStatisticsInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private QueryStatisticsProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of QueryStatisticsInner class.
     */
    public QueryStatisticsInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private QueryStatisticsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the databaseName property: Database name of the database in which this query was executed.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Get the queryId property: Unique query id (unique within one database).
     * 
     * @return the queryId value.
     */
    public String queryId() {
        return this.innerProperties() == null ? null : this.innerProperties().queryId();
    }

    /**
     * Get the startTime property: The start time for the metric (ISO-8601 format).
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the endTime property: The end time for the metric (ISO-8601 format).
     * 
     * @return the endTime value.
     */
    public String endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the intervals property: List of intervals with appropriate metric data.
     * 
     * @return the intervals value.
     */
    public List<QueryMetricInterval> intervals() {
        return this.innerProperties() == null ? null : this.innerProperties().intervals();
    }

    /**
     * Set the intervals property: List of intervals with appropriate metric data.
     * 
     * @param intervals the intervals value to set.
     * @return the QueryStatisticsInner object itself.
     */
    public QueryStatisticsInner withIntervals(List<QueryMetricInterval> intervals) {
        if (this.innerProperties() == null) {
            this.innerProperties = new QueryStatisticsProperties();
        }
        this.innerProperties().withIntervals(intervals);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryStatisticsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryStatisticsInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the QueryStatisticsInner.
     */
    public static QueryStatisticsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryStatisticsInner deserializedQueryStatisticsInner = new QueryStatisticsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedQueryStatisticsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedQueryStatisticsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedQueryStatisticsInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedQueryStatisticsInner.innerProperties = QueryStatisticsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryStatisticsInner;
        });
    }
}
