// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The recoverable database's properties.
 */
@Immutable
public final class RecoverableDatabaseProperties implements JsonSerializable<RecoverableDatabaseProperties> {
    /*
     * The edition of the database.
     */
    private String edition;

    /*
     * The service level objective name of the database.
     */
    private String serviceLevelObjective;

    /*
     * The elastic pool name of the database
     */
    private String elasticPoolName;

    /*
     * The last available backup date.
     */
    private OffsetDateTime lastAvailableBackupDate;

    /**
     * Creates an instance of RecoverableDatabaseProperties class.
     */
    public RecoverableDatabaseProperties() {
    }

    /**
     * Get the edition property: The edition of the database.
     * 
     * @return the edition value.
     */
    public String edition() {
        return this.edition;
    }

    /**
     * Get the serviceLevelObjective property: The service level objective name of the database.
     * 
     * @return the serviceLevelObjective value.
     */
    public String serviceLevelObjective() {
        return this.serviceLevelObjective;
    }

    /**
     * Get the elasticPoolName property: The elastic pool name of the database.
     * 
     * @return the elasticPoolName value.
     */
    public String elasticPoolName() {
        return this.elasticPoolName;
    }

    /**
     * Get the lastAvailableBackupDate property: The last available backup date.
     * 
     * @return the lastAvailableBackupDate value.
     */
    public OffsetDateTime lastAvailableBackupDate() {
        return this.lastAvailableBackupDate;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecoverableDatabaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecoverableDatabaseProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecoverableDatabaseProperties.
     */
    public static RecoverableDatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecoverableDatabaseProperties deserializedRecoverableDatabaseProperties
                = new RecoverableDatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("edition".equals(fieldName)) {
                    deserializedRecoverableDatabaseProperties.edition = reader.getString();
                } else if ("serviceLevelObjective".equals(fieldName)) {
                    deserializedRecoverableDatabaseProperties.serviceLevelObjective = reader.getString();
                } else if ("elasticPoolName".equals(fieldName)) {
                    deserializedRecoverableDatabaseProperties.elasticPoolName = reader.getString();
                } else if ("lastAvailableBackupDate".equals(fieldName)) {
                    deserializedRecoverableDatabaseProperties.lastAvailableBackupDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecoverableDatabaseProperties;
        });
    }
}
