// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ReplicationLinkType;
import com.azure.resourcemanager.sql.models.ReplicationRole;
import com.azure.resourcemanager.sql.models.ReplicationState;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties of a replication link.
 */
@Immutable
public final class ReplicationLinkProperties implements JsonSerializable<ReplicationLinkProperties> {
    /*
     * Resource partner server.
     */
    private String partnerServer;

    /*
     * Resource partner database.
     */
    private String partnerDatabase;

    /*
     * Resource partner location.
     */
    private String partnerLocation;

    /*
     * Local replication role.
     */
    private ReplicationRole role;

    /*
     * Partner replication role.
     */
    private ReplicationRole partnerRole;

    /*
     * Replication mode.
     */
    private String replicationMode;

    /*
     * Time at which the link was created.
     */
    private OffsetDateTime startTime;

    /*
     * Seeding completion percentage for the link.
     */
    private Integer percentComplete;

    /*
     * Replication state (PENDING, SEEDING, CATCHUP, SUSPENDED).
     */
    private ReplicationState replicationState;

    /*
     * Whether the user is currently allowed to terminate the link.
     */
    private Boolean isTerminationAllowed;

    /*
     * Link type (GEO, NAMED, STANDBY).
     */
    private ReplicationLinkType linkType;

    /**
     * Creates an instance of ReplicationLinkProperties class.
     */
    public ReplicationLinkProperties() {
    }

    /**
     * Get the partnerServer property: Resource partner server.
     * 
     * @return the partnerServer value.
     */
    public String partnerServer() {
        return this.partnerServer;
    }

    /**
     * Get the partnerDatabase property: Resource partner database.
     * 
     * @return the partnerDatabase value.
     */
    public String partnerDatabase() {
        return this.partnerDatabase;
    }

    /**
     * Get the partnerLocation property: Resource partner location.
     * 
     * @return the partnerLocation value.
     */
    public String partnerLocation() {
        return this.partnerLocation;
    }

    /**
     * Get the role property: Local replication role.
     * 
     * @return the role value.
     */
    public ReplicationRole role() {
        return this.role;
    }

    /**
     * Get the partnerRole property: Partner replication role.
     * 
     * @return the partnerRole value.
     */
    public ReplicationRole partnerRole() {
        return this.partnerRole;
    }

    /**
     * Get the replicationMode property: Replication mode.
     * 
     * @return the replicationMode value.
     */
    public String replicationMode() {
        return this.replicationMode;
    }

    /**
     * Get the startTime property: Time at which the link was created.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the percentComplete property: Seeding completion percentage for the link.
     * 
     * @return the percentComplete value.
     */
    public Integer percentComplete() {
        return this.percentComplete;
    }

    /**
     * Get the replicationState property: Replication state (PENDING, SEEDING, CATCHUP, SUSPENDED).
     * 
     * @return the replicationState value.
     */
    public ReplicationState replicationState() {
        return this.replicationState;
    }

    /**
     * Get the isTerminationAllowed property: Whether the user is currently allowed to terminate the link.
     * 
     * @return the isTerminationAllowed value.
     */
    public Boolean isTerminationAllowed() {
        return this.isTerminationAllowed;
    }

    /**
     * Get the linkType property: Link type (GEO, NAMED, STANDBY).
     * 
     * @return the linkType value.
     */
    public ReplicationLinkType linkType() {
        return this.linkType;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReplicationLinkProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReplicationLinkProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReplicationLinkProperties.
     */
    public static ReplicationLinkProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReplicationLinkProperties deserializedReplicationLinkProperties = new ReplicationLinkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("partnerServer".equals(fieldName)) {
                    deserializedReplicationLinkProperties.partnerServer = reader.getString();
                } else if ("partnerDatabase".equals(fieldName)) {
                    deserializedReplicationLinkProperties.partnerDatabase = reader.getString();
                } else if ("partnerLocation".equals(fieldName)) {
                    deserializedReplicationLinkProperties.partnerLocation = reader.getString();
                } else if ("role".equals(fieldName)) {
                    deserializedReplicationLinkProperties.role = ReplicationRole.fromString(reader.getString());
                } else if ("partnerRole".equals(fieldName)) {
                    deserializedReplicationLinkProperties.partnerRole = ReplicationRole.fromString(reader.getString());
                } else if ("replicationMode".equals(fieldName)) {
                    deserializedReplicationLinkProperties.replicationMode = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedReplicationLinkProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("percentComplete".equals(fieldName)) {
                    deserializedReplicationLinkProperties.percentComplete = reader.getNullable(JsonReader::getInt);
                } else if ("replicationState".equals(fieldName)) {
                    deserializedReplicationLinkProperties.replicationState
                        = ReplicationState.fromString(reader.getString());
                } else if ("isTerminationAllowed".equals(fieldName)) {
                    deserializedReplicationLinkProperties.isTerminationAllowed
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("linkType".equals(fieldName)) {
                    deserializedReplicationLinkProperties.linkType = ReplicationLinkType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReplicationLinkProperties;
        });
    }
}
