// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The license type to apply for this database. `LicenseIncluded` if you need a license, or `BasePrice` if you have a
 * license and are eligible for the Azure Hybrid Benefit.
 */
public final class DatabaseLicenseType extends ExpandableStringEnum<DatabaseLicenseType> {
    /**
     * Static value LicenseIncluded for DatabaseLicenseType.
     */
    public static final DatabaseLicenseType LICENSE_INCLUDED = fromString("LicenseIncluded");

    /**
     * Static value BasePrice for DatabaseLicenseType.
     */
    public static final DatabaseLicenseType BASE_PRICE = fromString("BasePrice");

    /**
     * Creates a new instance of DatabaseLicenseType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DatabaseLicenseType() {
    }

    /**
     * Creates or finds a DatabaseLicenseType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DatabaseLicenseType.
     */
    public static DatabaseLicenseType fromString(String name) {
        return fromString(name, DatabaseLicenseType.class);
    }

    /**
     * Gets known DatabaseLicenseType values.
     * 
     * @return known DatabaseLicenseType values.
     */
    public static Collection<DatabaseLicenseType> values() {
        return values(DatabaseLicenseType.class);
    }
}
