// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
 */
@Fluent
public final class DatabaseVulnerabilityAssessmentRuleBaselineItem
    implements JsonSerializable<DatabaseVulnerabilityAssessmentRuleBaselineItem> {
    /*
     * The rule baseline result
     */
    private List<String> result;

    /**
     * Creates an instance of DatabaseVulnerabilityAssessmentRuleBaselineItem class.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineItem() {
    }

    /**
     * Get the result property: The rule baseline result.
     * 
     * @return the result value.
     */
    public List<String> result() {
        return this.result;
    }

    /**
     * Set the result property: The rule baseline result.
     * 
     * @param result the result value to set.
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineItem object itself.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineItem withResult(List<String> result) {
        this.result = result;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (result() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property result in model DatabaseVulnerabilityAssessmentRuleBaselineItem"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatabaseVulnerabilityAssessmentRuleBaselineItem.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("result", this.result, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseVulnerabilityAssessmentRuleBaselineItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseVulnerabilityAssessmentRuleBaselineItem if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DatabaseVulnerabilityAssessmentRuleBaselineItem.
     */
    public static DatabaseVulnerabilityAssessmentRuleBaselineItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseVulnerabilityAssessmentRuleBaselineItem deserializedDatabaseVulnerabilityAssessmentRuleBaselineItem
                = new DatabaseVulnerabilityAssessmentRuleBaselineItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("result".equals(fieldName)) {
                    List<String> result = reader.readArray(reader1 -> reader1.getString());
                    deserializedDatabaseVulnerabilityAssessmentRuleBaselineItem.result = result;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseVulnerabilityAssessmentRuleBaselineItem;
        });
    }
}
