// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The maintenance configuration capability.
 */
@Fluent
public final class ManagedInstanceMaintenanceConfigurationCapability
    implements JsonSerializable<ManagedInstanceMaintenanceConfigurationCapability> {
    /*
     * Maintenance configuration name
     */
    private String name;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ManagedInstanceMaintenanceConfigurationCapability class.
     */
    public ManagedInstanceMaintenanceConfigurationCapability() {
    }

    /**
     * Get the name property: Maintenance configuration name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ManagedInstanceMaintenanceConfigurationCapability object itself.
     */
    public ManagedInstanceMaintenanceConfigurationCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceMaintenanceConfigurationCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceMaintenanceConfigurationCapability if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstanceMaintenanceConfigurationCapability.
     */
    public static ManagedInstanceMaintenanceConfigurationCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceMaintenanceConfigurationCapability deserializedManagedInstanceMaintenanceConfigurationCapability
                = new ManagedInstanceMaintenanceConfigurationCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedManagedInstanceMaintenanceConfigurationCapability.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedManagedInstanceMaintenanceConfigurationCapability.status
                        = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedManagedInstanceMaintenanceConfigurationCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceMaintenanceConfigurationCapability;
        });
    }
}
