// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ManagedInstancePrivateEndpointProperty model.
 */
@Fluent
public final class ManagedInstancePrivateEndpointProperty
    implements JsonSerializable<ManagedInstancePrivateEndpointProperty> {
    /*
     * Resource id of the private endpoint.
     */
    private String id;

    /**
     * Creates an instance of ManagedInstancePrivateEndpointProperty class.
     */
    public ManagedInstancePrivateEndpointProperty() {
    }

    /**
     * Get the id property: Resource id of the private endpoint.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource id of the private endpoint.
     * 
     * @param id the id value to set.
     * @return the ManagedInstancePrivateEndpointProperty object itself.
     */
    public ManagedInstancePrivateEndpointProperty withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstancePrivateEndpointProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstancePrivateEndpointProperty if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstancePrivateEndpointProperty.
     */
    public static ManagedInstancePrivateEndpointProperty fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstancePrivateEndpointProperty deserializedManagedInstancePrivateEndpointProperty
                = new ManagedInstancePrivateEndpointProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedInstancePrivateEndpointProperty.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstancePrivateEndpointProperty;
        });
    }
}
