// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ServerProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * An update request for an Azure SQL Database server.
 */
@Fluent
public final class ServerUpdate implements JsonSerializable<ServerUpdate> {
    /*
     * Server identity
     */
    private ResourceIdentity identity;

    /*
     * Resource properties.
     */
    private ServerProperties innerProperties;

    /*
     * Resource tags.
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of ServerUpdate class.
     */
    public ServerUpdate() {
    }

    /**
     * Get the identity property: Server identity.
     * 
     * @return the identity value.
     */
    public ResourceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Server identity.
     * 
     * @param identity the identity value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ServerProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the administratorLogin property: Administrator username for the server. Once created it cannot be changed.
     * 
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    /**
     * Set the administratorLogin property: Administrator username for the server. Once created it cannot be changed.
     * 
     * @param administratorLogin the administratorLogin value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    /**
     * Set the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    /**
     * Get the version property: The version of the server.
     * 
     * @return the version value.
     */
    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Set the version property: The version of the server.
     * 
     * @param version the version value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    /**
     * Get the state property: The state of the server.
     * 
     * @return the state value.
     */
    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of the server.
     * 
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections on a server.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    /**
     * Get the minimalTlsVersion property: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
     * 
     * @return the minimalTlsVersion value.
     */
    public String minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    /**
     * Set the minimalTlsVersion property: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
     * 
     * @param minimalTlsVersion the minimalTlsVersion value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withMinimalTlsVersion(String minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public endpoint access is allowed for this server. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @return the publicNetworkAccess value.
     */
    public ServerNetworkAccessFlag publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public endpoint access is allowed for this server. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withPublicNetworkAccess(ServerNetworkAccessFlag publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    /**
     * Get the workspaceFeature property: Whether or not existing server has a workspace created and if it allows
     * connection from workspace.
     * 
     * @return the workspaceFeature value.
     */
    public ServerWorkspaceFeature workspaceFeature() {
        return this.innerProperties() == null ? null : this.innerProperties().workspaceFeature();
    }

    /**
     * Get the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     * 
     * @return the primaryUserAssignedIdentityId value.
     */
    public String primaryUserAssignedIdentityId() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryUserAssignedIdentityId();
    }

    /**
     * Set the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     * 
     * @param primaryUserAssignedIdentityId the primaryUserAssignedIdentityId value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPrimaryUserAssignedIdentityId(primaryUserAssignedIdentityId);
        return this;
    }

    /**
     * Get the federatedClientId property: The Client id used for cross tenant CMK scenario.
     * 
     * @return the federatedClientId value.
     */
    public UUID federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    /**
     * Set the federatedClientId property: The Client id used for cross tenant CMK scenario.
     * 
     * @param federatedClientId the federatedClientId value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withFederatedClientId(UUID federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    /**
     * Get the keyId property: A CMK URI of the key to use for encryption.
     * 
     * @return the keyId value.
     */
    public String keyId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyId();
    }

    /**
     * Set the keyId property: A CMK URI of the key to use for encryption.
     * 
     * @param keyId the keyId value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withKeyId(String keyId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withKeyId(keyId);
        return this;
    }

    /**
     * Get the administrators property: The Azure Active Directory administrator of the server.
     * 
     * @return the administrators value.
     */
    public ServerExternalAdministrator administrators() {
        return this.innerProperties() == null ? null : this.innerProperties().administrators();
    }

    /**
     * Set the administrators property: The Azure Active Directory administrator of the server.
     * 
     * @param administrators the administrators value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withAdministrators(ServerExternalAdministrator administrators) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministrators(administrators);
        return this;
    }

    /**
     * Get the restrictOutboundNetworkAccess property: Whether or not to restrict outbound network access for this
     * server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @return the restrictOutboundNetworkAccess value.
     */
    public ServerNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().restrictOutboundNetworkAccess();
    }

    /**
     * Set the restrictOutboundNetworkAccess property: Whether or not to restrict outbound network access for this
     * server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     * 
     * @param restrictOutboundNetworkAccess the restrictOutboundNetworkAccess value to set.
     * @return the ServerUpdate object itself.
     */
    public ServerUpdate withRestrictOutboundNetworkAccess(ServerNetworkAccessFlag restrictOutboundNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withRestrictOutboundNetworkAccess(restrictOutboundNetworkAccess);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerUpdate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerUpdate.
     */
    public static ServerUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerUpdate deserializedServerUpdate = new ServerUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identity".equals(fieldName)) {
                    deserializedServerUpdate.identity = ResourceIdentity.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedServerUpdate.innerProperties = ServerProperties.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServerUpdate.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerUpdate;
        });
    }
}
