// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the export operation's result.
 */
@Immutable
public final class DatabaseVulnerabilityAssessmentScanExportProperties
    implements JsonSerializable<DatabaseVulnerabilityAssessmentScanExportProperties> {
    /*
     * Location of the exported report (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     */
    private String exportedReportLocation;

    /**
     * Creates an instance of DatabaseVulnerabilityAssessmentScanExportProperties class.
     */
    public DatabaseVulnerabilityAssessmentScanExportProperties() {
    }

    /**
     * Get the exportedReportLocation property: Location of the exported report (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     * 
     * @return the exportedReportLocation value.
     */
    public String exportedReportLocation() {
        return this.exportedReportLocation;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseVulnerabilityAssessmentScanExportProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseVulnerabilityAssessmentScanExportProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseVulnerabilityAssessmentScanExportProperties.
     */
    public static DatabaseVulnerabilityAssessmentScanExportProperties fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseVulnerabilityAssessmentScanExportProperties deserializedDatabaseVulnerabilityAssessmentScanExportProperties
                = new DatabaseVulnerabilityAssessmentScanExportProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("exportedReportLocation".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentScanExportProperties.exportedReportLocation
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseVulnerabilityAssessmentScanExportProperties;
        });
    }
}
