// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import java.io.IOException;
import java.util.UUID;

/**
 * A LongTermRetentionBackup operation result resource.
 */
@Immutable
public final class LongTermRetentionBackupOperationResultInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private LongTermRetentionOperationResultProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of LongTermRetentionBackupOperationResultInner class.
     */
    public LongTermRetentionBackupOperationResultInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private LongTermRetentionOperationResultProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the requestId property: Request Id.
     * 
     * @return the requestId value.
     */
    public UUID requestId() {
        return this.innerProperties() == null ? null : this.innerProperties().requestId();
    }

    /**
     * Get the operationType property: Operation type.
     * 
     * @return the operationType value.
     */
    public String operationType() {
        return this.innerProperties() == null ? null : this.innerProperties().operationType();
    }

    /**
     * Get the fromBackupResourceId property: Source backup resource id.
     * 
     * @return the fromBackupResourceId value.
     */
    public String fromBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().fromBackupResourceId();
    }

    /**
     * Get the toBackupResourceId property: Target backup resource id.
     * 
     * @return the toBackupResourceId value.
     */
    public String toBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().toBackupResourceId();
    }

    /**
     * Get the targetBackupStorageRedundancy property: The storage redundancy type of the copied backup.
     * 
     * @return the targetBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy targetBackupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().targetBackupStorageRedundancy();
    }

    /**
     * Get the status property: Operation status.
     * 
     * @return the status value.
     */
    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the message property: Progress message.
     * 
     * @return the message value.
     */
    public String message() {
        return this.innerProperties() == null ? null : this.innerProperties().message();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LongTermRetentionBackupOperationResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LongTermRetentionBackupOperationResultInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LongTermRetentionBackupOperationResultInner.
     */
    public static LongTermRetentionBackupOperationResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LongTermRetentionBackupOperationResultInner deserializedLongTermRetentionBackupOperationResultInner
                = new LongTermRetentionBackupOperationResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLongTermRetentionBackupOperationResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedLongTermRetentionBackupOperationResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedLongTermRetentionBackupOperationResultInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedLongTermRetentionBackupOperationResultInner.innerProperties
                        = LongTermRetentionOperationResultProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLongTermRetentionBackupOperationResultInner;
        });
    }
}
