// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SecurityEventSqlInjectionAdditionalProperties;
import com.azure.resourcemanager.sql.models.SecurityEventType;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The properties of a security event.
 */
@Immutable
public final class SecurityEventProperties implements JsonSerializable<SecurityEventProperties> {
    /*
     * The time when the security event occurred.
     */
    private OffsetDateTime eventTime;

    /*
     * The type of the security event.
     */
    private SecurityEventType securityEventType;

    /*
     * The subscription name
     */
    private String subscription;

    /*
     * The server name
     */
    private String server;

    /*
     * The database name
     */
    private String database;

    /*
     * The IP address of the client who executed the statement.
     */
    private String clientIp;

    /*
     * The application used to execute the statement.
     */
    private String applicationName;

    /*
     * The principal user who executed the statement
     */
    private String principalName;

    /*
     * The sql injection additional properties, populated only if the type of the security event is sql injection.
     */
    private SecurityEventSqlInjectionAdditionalProperties securityEventSqlInjectionAdditionalProperties;

    /**
     * Creates an instance of SecurityEventProperties class.
     */
    public SecurityEventProperties() {
    }

    /**
     * Get the eventTime property: The time when the security event occurred.
     * 
     * @return the eventTime value.
     */
    public OffsetDateTime eventTime() {
        return this.eventTime;
    }

    /**
     * Get the securityEventType property: The type of the security event.
     * 
     * @return the securityEventType value.
     */
    public SecurityEventType securityEventType() {
        return this.securityEventType;
    }

    /**
     * Get the subscription property: The subscription name.
     * 
     * @return the subscription value.
     */
    public String subscription() {
        return this.subscription;
    }

    /**
     * Get the server property: The server name.
     * 
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Get the database property: The database name.
     * 
     * @return the database value.
     */
    public String database() {
        return this.database;
    }

    /**
     * Get the clientIp property: The IP address of the client who executed the statement.
     * 
     * @return the clientIp value.
     */
    public String clientIp() {
        return this.clientIp;
    }

    /**
     * Get the applicationName property: The application used to execute the statement.
     * 
     * @return the applicationName value.
     */
    public String applicationName() {
        return this.applicationName;
    }

    /**
     * Get the principalName property: The principal user who executed the statement.
     * 
     * @return the principalName value.
     */
    public String principalName() {
        return this.principalName;
    }

    /**
     * Get the securityEventSqlInjectionAdditionalProperties property: The sql injection additional properties,
     * populated only if the type of the security event is sql injection.
     * 
     * @return the securityEventSqlInjectionAdditionalProperties value.
     */
    public SecurityEventSqlInjectionAdditionalProperties securityEventSqlInjectionAdditionalProperties() {
        return this.securityEventSqlInjectionAdditionalProperties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (securityEventSqlInjectionAdditionalProperties() != null) {
            securityEventSqlInjectionAdditionalProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityEventProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityEventProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityEventProperties.
     */
    public static SecurityEventProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityEventProperties deserializedSecurityEventProperties = new SecurityEventProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("eventTime".equals(fieldName)) {
                    deserializedSecurityEventProperties.eventTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("securityEventType".equals(fieldName)) {
                    deserializedSecurityEventProperties.securityEventType
                        = SecurityEventType.fromString(reader.getString());
                } else if ("subscription".equals(fieldName)) {
                    deserializedSecurityEventProperties.subscription = reader.getString();
                } else if ("server".equals(fieldName)) {
                    deserializedSecurityEventProperties.server = reader.getString();
                } else if ("database".equals(fieldName)) {
                    deserializedSecurityEventProperties.database = reader.getString();
                } else if ("clientIp".equals(fieldName)) {
                    deserializedSecurityEventProperties.clientIp = reader.getString();
                } else if ("applicationName".equals(fieldName)) {
                    deserializedSecurityEventProperties.applicationName = reader.getString();
                } else if ("principalName".equals(fieldName)) {
                    deserializedSecurityEventProperties.principalName = reader.getString();
                } else if ("securityEventSqlInjectionAdditionalProperties".equals(fieldName)) {
                    deserializedSecurityEventProperties.securityEventSqlInjectionAdditionalProperties
                        = SecurityEventSqlInjectionAdditionalProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityEventProperties;
        });
    }
}
