// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The managed instance capability.
 */
@Fluent
public final class ManagedInstanceVersionCapability implements JsonSerializable<ManagedInstanceVersionCapability> {
    /*
     * The server version name.
     */
    private String name;

    /*
     * The list of supported managed instance editions.
     */
    private List<ManagedInstanceEditionCapability> supportedEditions;

    /*
     * The list of supported instance pool editions.
     */
    private List<InstancePoolEditionCapability> supportedInstancePoolEditions;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ManagedInstanceVersionCapability class.
     */
    public ManagedInstanceVersionCapability() {
    }

    /**
     * Get the name property: The server version name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the supportedEditions property: The list of supported managed instance editions.
     * 
     * @return the supportedEditions value.
     */
    public List<ManagedInstanceEditionCapability> supportedEditions() {
        return this.supportedEditions;
    }

    /**
     * Get the supportedInstancePoolEditions property: The list of supported instance pool editions.
     * 
     * @return the supportedInstancePoolEditions value.
     */
    public List<InstancePoolEditionCapability> supportedInstancePoolEditions() {
        return this.supportedInstancePoolEditions;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ManagedInstanceVersionCapability object itself.
     */
    public ManagedInstanceVersionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedEditions() != null) {
            supportedEditions().forEach(e -> e.validate());
        }
        if (supportedInstancePoolEditions() != null) {
            supportedInstancePoolEditions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceVersionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceVersionCapability if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstanceVersionCapability.
     */
    public static ManagedInstanceVersionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceVersionCapability deserializedManagedInstanceVersionCapability
                = new ManagedInstanceVersionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedManagedInstanceVersionCapability.name = reader.getString();
                } else if ("supportedEditions".equals(fieldName)) {
                    List<ManagedInstanceEditionCapability> supportedEditions
                        = reader.readArray(reader1 -> ManagedInstanceEditionCapability.fromJson(reader1));
                    deserializedManagedInstanceVersionCapability.supportedEditions = supportedEditions;
                } else if ("supportedInstancePoolEditions".equals(fieldName)) {
                    List<InstancePoolEditionCapability> supportedInstancePoolEditions
                        = reader.readArray(reader1 -> InstancePoolEditionCapability.fromJson(reader1));
                    deserializedManagedInstanceVersionCapability.supportedInstancePoolEditions
                        = supportedInstancePoolEditions;
                } else if ("status".equals(fieldName)) {
                    deserializedManagedInstanceVersionCapability.status
                        = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedManagedInstanceVersionCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceVersionCapability;
        });
    }
}
