// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

/**
 * Defines values for SensitivityLabelSource.
 */
public enum SensitivityLabelSource {
    /**
     * Enum value current.
     */
    CURRENT("current"),

    /**
     * Enum value recommended.
     */
    RECOMMENDED("recommended");

    /**
     * The actual serialized value for a SensitivityLabelSource instance.
     */
    private final String value;

    SensitivityLabelSource(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SensitivityLabelSource instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed SensitivityLabelSource object, or null if unable to parse.
     */
    public static SensitivityLabelSource fromString(String value) {
        if (value == null) {
            return null;
        }
        SensitivityLabelSource[] items = SensitivityLabelSource.values();
        for (SensitivityLabelSource item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
