// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The server capability.
 */
@Fluent
public final class ServerVersionCapability implements JsonSerializable<ServerVersionCapability> {
    /*
     * The server version name.
     */
    private String name;

    /*
     * The list of supported database editions.
     */
    private List<EditionCapability> supportedEditions;

    /*
     * The list of supported elastic pool editions.
     */
    private List<ElasticPoolEditionCapability> supportedElasticPoolEditions;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ServerVersionCapability class.
     */
    public ServerVersionCapability() {
    }

    /**
     * Get the name property: The server version name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the supportedEditions property: The list of supported database editions.
     * 
     * @return the supportedEditions value.
     */
    public List<EditionCapability> supportedEditions() {
        return this.supportedEditions;
    }

    /**
     * Get the supportedElasticPoolEditions property: The list of supported elastic pool editions.
     * 
     * @return the supportedElasticPoolEditions value.
     */
    public List<ElasticPoolEditionCapability> supportedElasticPoolEditions() {
        return this.supportedElasticPoolEditions;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ServerVersionCapability object itself.
     */
    public ServerVersionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedEditions() != null) {
            supportedEditions().forEach(e -> e.validate());
        }
        if (supportedElasticPoolEditions() != null) {
            supportedElasticPoolEditions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerVersionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerVersionCapability if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerVersionCapability.
     */
    public static ServerVersionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerVersionCapability deserializedServerVersionCapability = new ServerVersionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedServerVersionCapability.name = reader.getString();
                } else if ("supportedEditions".equals(fieldName)) {
                    List<EditionCapability> supportedEditions
                        = reader.readArray(reader1 -> EditionCapability.fromJson(reader1));
                    deserializedServerVersionCapability.supportedEditions = supportedEditions;
                } else if ("supportedElasticPoolEditions".equals(fieldName)) {
                    List<ElasticPoolEditionCapability> supportedElasticPoolEditions
                        = reader.readArray(reader1 -> ElasticPoolEditionCapability.fromJson(reader1));
                    deserializedServerVersionCapability.supportedElasticPoolEditions = supportedElasticPoolEditions;
                } else if ("status".equals(fieldName)) {
                    deserializedServerVersionCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedServerVersionCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerVersionCapability;
        });
    }
}
