/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SensitivityLabelRank;
import java.io.IOException;

public final class SensitivityLabelProperties
implements JsonSerializable<SensitivityLabelProperties> {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String labelName;
    private String labelId;
    private String informationType;
    private String informationTypeId;
    private Boolean isDisabled;
    private SensitivityLabelRank rank;

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tableName;
    }

    public String columnName() {
        return this.columnName;
    }

    public String labelName() {
        return this.labelName;
    }

    public SensitivityLabelProperties withLabelName(String labelName) {
        this.labelName = labelName;
        return this;
    }

    public String labelId() {
        return this.labelId;
    }

    public SensitivityLabelProperties withLabelId(String labelId) {
        this.labelId = labelId;
        return this;
    }

    public String informationType() {
        return this.informationType;
    }

    public SensitivityLabelProperties withInformationType(String informationType) {
        this.informationType = informationType;
        return this;
    }

    public String informationTypeId() {
        return this.informationTypeId;
    }

    public SensitivityLabelProperties withInformationTypeId(String informationTypeId) {
        this.informationTypeId = informationTypeId;
        return this;
    }

    public Boolean isDisabled() {
        return this.isDisabled;
    }

    public SensitivityLabelRank rank() {
        return this.rank;
    }

    public SensitivityLabelProperties withRank(SensitivityLabelRank rank) {
        this.rank = rank;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("labelName", this.labelName);
        jsonWriter.writeStringField("labelId", this.labelId);
        jsonWriter.writeStringField("informationType", this.informationType);
        jsonWriter.writeStringField("informationTypeId", this.informationTypeId);
        jsonWriter.writeStringField("rank", this.rank == null ? null : this.rank.toString());
        return jsonWriter.writeEndObject();
    }

    public static SensitivityLabelProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SensitivityLabelProperties)jsonReader.readObject(reader -> {
            SensitivityLabelProperties deserializedSensitivityLabelProperties = new SensitivityLabelProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaName".equals(fieldName)) {
                    deserializedSensitivityLabelProperties.schemaName = reader.getString();
                    continue;
                }
                if ("tableName".equals(fieldName)) {
                    deserializedSensitivityLabelProperties.tableName = reader.getString();
                    continue;
                }
                if ("columnName".equals(fieldName)) {
                    deserializedSensitivityLabelProperties.columnName = reader.getString();
                    continue;
                }
                if ("labelName".equals(fieldName)) {
                    deserializedSensitivityLabelProperties.labelName = reader.getString();
                    continue;
                }
                if ("labelId".equals(fieldName)) {
                    deserializedSensitivityLabelProperties.labelId = reader.getString();
                    continue;
                }
                if ("informationType".equals(fieldName)) {
                    deserializedSensitivityLabelProperties.informationType = reader.getString();
                    continue;
                }
                if ("informationTypeId".equals(fieldName)) {
                    deserializedSensitivityLabelProperties.informationTypeId = reader.getString();
                    continue;
                }
                if ("isDisabled".equals(fieldName)) {
                    deserializedSensitivityLabelProperties.isDisabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("rank".equals(fieldName)) {
                    deserializedSensitivityLabelProperties.rank = SensitivityLabelRank.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSensitivityLabelProperties;
        });
    }
}

