/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.LogSizeCapability;
import com.azure.resourcemanager.sql.models.MaxSizeCapability;
import java.io.IOException;

public final class MaxSizeRangeCapability
implements JsonSerializable<MaxSizeRangeCapability> {
    private MaxSizeCapability minValue;
    private MaxSizeCapability maxValue;
    private MaxSizeCapability scaleSize;
    private LogSizeCapability logSize;
    private CapabilityStatus status;
    private String reason;

    public MaxSizeCapability minValue() {
        return this.minValue;
    }

    public MaxSizeCapability maxValue() {
        return this.maxValue;
    }

    public MaxSizeCapability scaleSize() {
        return this.scaleSize;
    }

    public LogSizeCapability logSize() {
        return this.logSize;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public MaxSizeRangeCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.minValue() != null) {
            this.minValue().validate();
        }
        if (this.maxValue() != null) {
            this.maxValue().validate();
        }
        if (this.scaleSize() != null) {
            this.scaleSize().validate();
        }
        if (this.logSize() != null) {
            this.logSize().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static MaxSizeRangeCapability fromJson(JsonReader jsonReader) throws IOException {
        return (MaxSizeRangeCapability)jsonReader.readObject(reader -> {
            MaxSizeRangeCapability deserializedMaxSizeRangeCapability = new MaxSizeRangeCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minValue".equals(fieldName)) {
                    deserializedMaxSizeRangeCapability.minValue = MaxSizeCapability.fromJson(reader);
                    continue;
                }
                if ("maxValue".equals(fieldName)) {
                    deserializedMaxSizeRangeCapability.maxValue = MaxSizeCapability.fromJson(reader);
                    continue;
                }
                if ("scaleSize".equals(fieldName)) {
                    deserializedMaxSizeRangeCapability.scaleSize = MaxSizeCapability.fromJson(reader);
                    continue;
                }
                if ("logSize".equals(fieldName)) {
                    deserializedMaxSizeRangeCapability.logSize = LogSizeCapability.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMaxSizeRangeCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedMaxSizeRangeCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMaxSizeRangeCapability;
        });
    }
}

