/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.ElasticPoolPerformanceLevelCapability;
import java.io.IOException;
import java.util.List;

public final class ElasticPoolEditionCapability
implements JsonSerializable<ElasticPoolEditionCapability> {
    private String name;
    private List<ElasticPoolPerformanceLevelCapability> supportedElasticPoolPerformanceLevels;
    private Boolean zoneRedundant;
    private CapabilityStatus status;
    private String reason;

    public String name() {
        return this.name;
    }

    public List<ElasticPoolPerformanceLevelCapability> supportedElasticPoolPerformanceLevels() {
        return this.supportedElasticPoolPerformanceLevels;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public ElasticPoolEditionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedElasticPoolPerformanceLevels() != null) {
            this.supportedElasticPoolPerformanceLevels().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static ElasticPoolEditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticPoolEditionCapability)jsonReader.readObject(reader -> {
            ElasticPoolEditionCapability deserializedElasticPoolEditionCapability = new ElasticPoolEditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedElasticPoolEditionCapability.name = reader.getString();
                    continue;
                }
                if ("supportedElasticPoolPerformanceLevels".equals(fieldName)) {
                    List supportedElasticPoolPerformanceLevels;
                    deserializedElasticPoolEditionCapability.supportedElasticPoolPerformanceLevels = supportedElasticPoolPerformanceLevels = reader.readArray(reader1 -> ElasticPoolPerformanceLevelCapability.fromJson(reader1));
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedElasticPoolEditionCapability.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedElasticPoolEditionCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedElasticPoolEditionCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticPoolEditionCapability;
        });
    }
}

