/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseMinPerformanceLevelCapability;
import com.azure.resourcemanager.sql.models.PerformanceLevelUnit;
import java.io.IOException;
import java.util.List;

public final class ElasticPoolPerDatabaseMaxPerformanceLevelCapability
implements JsonSerializable<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> {
    private Double limit;
    private PerformanceLevelUnit unit;
    private List<ElasticPoolPerDatabaseMinPerformanceLevelCapability> supportedPerDatabaseMinPerformanceLevels;
    private CapabilityStatus status;
    private String reason;

    public Double limit() {
        return this.limit;
    }

    public PerformanceLevelUnit unit() {
        return this.unit;
    }

    public List<ElasticPoolPerDatabaseMinPerformanceLevelCapability> supportedPerDatabaseMinPerformanceLevels() {
        return this.supportedPerDatabaseMinPerformanceLevels;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public ElasticPoolPerDatabaseMaxPerformanceLevelCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedPerDatabaseMinPerformanceLevels() != null) {
            this.supportedPerDatabaseMinPerformanceLevels().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static ElasticPoolPerDatabaseMaxPerformanceLevelCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticPoolPerDatabaseMaxPerformanceLevelCapability)jsonReader.readObject(reader -> {
            ElasticPoolPerDatabaseMaxPerformanceLevelCapability deserializedElasticPoolPerDatabaseMaxPerformanceLevelCapability = new ElasticPoolPerDatabaseMaxPerformanceLevelCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("limit".equals(fieldName)) {
                    deserializedElasticPoolPerDatabaseMaxPerformanceLevelCapability.limit = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedElasticPoolPerDatabaseMaxPerformanceLevelCapability.unit = PerformanceLevelUnit.fromString(reader.getString());
                    continue;
                }
                if ("supportedPerDatabaseMinPerformanceLevels".equals(fieldName)) {
                    List supportedPerDatabaseMinPerformanceLevels;
                    deserializedElasticPoolPerDatabaseMaxPerformanceLevelCapability.supportedPerDatabaseMinPerformanceLevels = supportedPerDatabaseMinPerformanceLevels = reader.readArray(reader1 -> ElasticPoolPerDatabaseMinPerformanceLevelCapability.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedElasticPoolPerDatabaseMaxPerformanceLevelCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedElasticPoolPerDatabaseMaxPerformanceLevelCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticPoolPerDatabaseMaxPerformanceLevelCapability;
        });
    }
}

