/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.DatabaseEdition;
import com.azure.resourcemanager.sql.models.ExportRequest;
import com.azure.resourcemanager.sql.models.ServiceObjectiveName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ImportRequest
extends ExportRequest {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImportRequest.class);
    @JsonProperty(value="databaseName", required=true)
    private String databaseName;
    @JsonProperty(value="edition", required=true)
    private DatabaseEdition edition;
    @JsonProperty(value="serviceObjectiveName", required=true)
    private ServiceObjectiveName serviceObjectiveName;
    @JsonProperty(value="maxSizeBytes", required=true)
    private String maxSizeBytes;

    public String databaseName() {
        return this.databaseName;
    }

    public ImportRequest withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public DatabaseEdition edition() {
        return this.edition;
    }

    public ImportRequest withEdition(DatabaseEdition edition) {
        this.edition = edition;
        return this;
    }

    public ServiceObjectiveName serviceObjectiveName() {
        return this.serviceObjectiveName;
    }

    public ImportRequest withServiceObjectiveName(ServiceObjectiveName serviceObjectiveName) {
        this.serviceObjectiveName = serviceObjectiveName;
        return this;
    }

    public String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public ImportRequest withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.databaseName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property databaseName in model ImportRequest"));
        }
        if (this.edition() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property edition in model ImportRequest"));
        }
        if (this.serviceObjectiveName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property serviceObjectiveName in model ImportRequest"));
        }
        if (this.maxSizeBytes() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property maxSizeBytes in model ImportRequest"));
        }
    }
}

