// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A database vulnerability assessment rule baseline. */
@JsonFlatten
@Fluent
public class DatabaseVulnerabilityAssessmentRuleBaselineInner extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DatabaseVulnerabilityAssessmentRuleBaselineInner.class);

    /*
     * The rule baseline result
     */
    @JsonProperty(value = "properties.baselineResults")
    private List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults;

    /**
     * Get the baselineResults property: The rule baseline result.
     *
     * @return the baselineResults value.
     */
    public List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults() {
        return this.baselineResults;
    }

    /**
     * Set the baselineResults property: The rule baseline result.
     *
     * @param baselineResults the baselineResults value to set.
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineInner object itself.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineInner withBaselineResults(
        List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        this.baselineResults = baselineResults;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (baselineResults() != null) {
            baselineResults().forEach(e -> e.validate());
        }
    }
}
