// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A database Vulnerability Assessment scan export resource. */
@JsonFlatten
@Immutable
public class DatabaseVulnerabilityAssessmentScansExportInner extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DatabaseVulnerabilityAssessmentScansExportInner.class);

    /*
     * Location of the exported report (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     */
    @JsonProperty(value = "properties.exportedReportLocation", access = JsonProperty.Access.WRITE_ONLY)
    private String exportedReportLocation;

    /**
     * Get the exportedReportLocation property: Location of the exported report (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     *
     * @return the exportedReportLocation value.
     */
    public String exportedReportLocation() {
        return this.exportedReportLocation;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
