// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.ManagedInstancePairInfo;
import com.azure.resourcemanager.sql.models.PartnerRegionInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An instance failover group. */
@JsonFlatten
@Fluent
public class InstanceFailoverGroupInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(InstanceFailoverGroupInner.class);

    /*
     * Read-write endpoint of the failover group instance.
     */
    @JsonProperty(value = "properties.readWriteEndpoint")
    private InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint;

    /*
     * Read-only endpoint of the failover group instance.
     */
    @JsonProperty(value = "properties.readOnlyEndpoint")
    private InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint;

    /*
     * Local replication role of the failover group instance.
     */
    @JsonProperty(value = "properties.replicationRole", access = JsonProperty.Access.WRITE_ONLY)
    private InstanceFailoverGroupReplicationRole replicationRole;

    /*
     * Replication state of the failover group instance.
     */
    @JsonProperty(value = "properties.replicationState", access = JsonProperty.Access.WRITE_ONLY)
    private String replicationState;

    /*
     * Partner region information for the failover group.
     */
    @JsonProperty(value = "properties.partnerRegions")
    private List<PartnerRegionInfo> partnerRegions;

    /*
     * List of managed instance pairs in the failover group.
     */
    @JsonProperty(value = "properties.managedInstancePairs")
    private List<ManagedInstancePairInfo> managedInstancePairs;

    /**
     * Get the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     *
     * @return the readWriteEndpoint value.
     */
    public InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    /**
     * Set the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     *
     * @param readWriteEndpoint the readWriteEndpoint value to set.
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withReadWriteEndpoint(InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    /**
     * Get the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     *
     * @return the readOnlyEndpoint value.
     */
    public InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    /**
     * Set the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     *
     * @param readOnlyEndpoint the readOnlyEndpoint value to set.
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withReadOnlyEndpoint(InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    /**
     * Get the replicationRole property: Local replication role of the failover group instance.
     *
     * @return the replicationRole value.
     */
    public InstanceFailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    /**
     * Get the replicationState property: Replication state of the failover group instance.
     *
     * @return the replicationState value.
     */
    public String replicationState() {
        return this.replicationState;
    }

    /**
     * Get the partnerRegions property: Partner region information for the failover group.
     *
     * @return the partnerRegions value.
     */
    public List<PartnerRegionInfo> partnerRegions() {
        return this.partnerRegions;
    }

    /**
     * Set the partnerRegions property: Partner region information for the failover group.
     *
     * @param partnerRegions the partnerRegions value to set.
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withPartnerRegions(List<PartnerRegionInfo> partnerRegions) {
        this.partnerRegions = partnerRegions;
        return this;
    }

    /**
     * Get the managedInstancePairs property: List of managed instance pairs in the failover group.
     *
     * @return the managedInstancePairs value.
     */
    public List<ManagedInstancePairInfo> managedInstancePairs() {
        return this.managedInstancePairs;
    }

    /**
     * Set the managedInstancePairs property: List of managed instance pairs in the failover group.
     *
     * @param managedInstancePairs the managedInstancePairs value to set.
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withManagedInstancePairs(List<ManagedInstancePairInfo> managedInstancePairs) {
        this.managedInstancePairs = managedInstancePairs;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (readWriteEndpoint() != null) {
            readWriteEndpoint().validate();
        }
        if (readOnlyEndpoint() != null) {
            readOnlyEndpoint().validate();
        }
        if (partnerRegions() != null) {
            partnerRegions().forEach(e -> e.validate());
        }
        if (managedInstancePairs() != null) {
            managedInstancePairs().forEach(e -> e.validate());
        }
    }
}
