// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.fluent.models.DatabaseUsageInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response to a list database metrics request. */
@Fluent
public final class DatabaseUsageListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DatabaseUsageListResult.class);

    /*
     * The list of database usages for the database.
     */
    @JsonProperty(value = "value", required = true)
    private List<DatabaseUsageInner> value;

    /**
     * Get the value property: The list of database usages for the database.
     *
     * @return the value value.
     */
    public List<DatabaseUsageInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of database usages for the database.
     *
     * @param value the value value to set.
     * @return the DatabaseUsageListResult object itself.
     */
    public DatabaseUsageListResult withValue(List<DatabaseUsageInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property value in model DatabaseUsageListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }
}
