// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents the properties for an import operation. */
@Fluent
public final class ImportExtensionProperties extends ExportRequest {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ImportExtensionProperties.class);

    /*
     * The type of import operation being performed. This is always Import.
     */
    @JsonProperty(value = "operationMode", required = true)
    private String operationMode;

    /** Creates an instance of ImportExtensionProperties class. */
    public ImportExtensionProperties() {
        operationMode = "Import";
    }

    /**
     * Get the operationMode property: The type of import operation being performed. This is always Import.
     *
     * @return the operationMode value.
     */
    public String operationMode() {
        return this.operationMode;
    }

    /**
     * Set the operationMode property: The type of import operation being performed. This is always Import.
     *
     * @param operationMode the operationMode value to set.
     * @return the ImportExtensionProperties object itself.
     */
    public ImportExtensionProperties withOperationMode(String operationMode) {
        this.operationMode = operationMode;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
