// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.storage.fluent.models.BlobRestoreStatusInner;
import com.azure.resourcemanager.storage.fluent.models.CheckNameAvailabilityResultInner;
import com.azure.resourcemanager.storage.fluent.models.ListAccountSasResponseInner;
import com.azure.resourcemanager.storage.fluent.models.ListServiceSasResponseInner;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountListKeysResultInner;
import com.azure.resourcemanager.storage.models.AccountSasParameters;
import com.azure.resourcemanager.storage.models.BlobRestoreRange;
import com.azure.resourcemanager.storage.models.ListKeyExpand;
import com.azure.resourcemanager.storage.models.ServiceSasParameters;
import com.azure.resourcemanager.storage.models.StorageAccountCreateParameters;
import com.azure.resourcemanager.storage.models.StorageAccountExpand;
import com.azure.resourcemanager.storage.models.StorageAccountUpdateParameters;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in StorageAccountsClient. */
public interface StorageAccountsClient
    extends InnerSupportsGet<StorageAccountInner>,
        InnerSupportsListing<StorageAccountInner>,
        InnerSupportsDelete<Void> {
    /**
     * Checks that the storage account name is valid and is not already in use.
     *
     * @param name The storage account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckNameAvailability operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithResponseAsync(String name);

    /**
     * Checks that the storage account name is valid and is not already in use.
     *
     * @param name The storage account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckNameAvailability operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name);

    /**
     * Checks that the storage account name is valid and is not already in use.
     *
     * @param name The storage account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckNameAvailability operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CheckNameAvailabilityResultInner checkNameAvailability(String name);

    /**
     * Checks that the storage account name is valid and is not already in use.
     *
     * @param name The storage account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the CheckNameAvailability operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CheckNameAvailabilityResultInner> checkNameAvailabilityWithResponse(String name, Context context);

    /**
     * Asynchronously creates a new storage account with the specified parameters. If an account is already created and
     * a subsequent create request is issued with different properties, the account properties will be updated. If an
     * account is already created and a subsequent create or update request is issued with the exact same set of
     * properties, the request will succeed.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters used when creating a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String accountName, StorageAccountCreateParameters parameters);

    /**
     * Asynchronously creates a new storage account with the specified parameters. If an account is already created and
     * a subsequent create request is issued with different properties, the account properties will be updated. If an
     * account is already created and a subsequent create or update request is issued with the exact same set of
     * properties, the request will succeed.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters used when creating a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<StorageAccountInner>, StorageAccountInner> beginCreateAsync(
        String resourceGroupName, String accountName, StorageAccountCreateParameters parameters);

    /**
     * Asynchronously creates a new storage account with the specified parameters. If an account is already created and
     * a subsequent create request is issued with different properties, the account properties will be updated. If an
     * account is already created and a subsequent create or update request is issued with the exact same set of
     * properties, the request will succeed.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters used when creating a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<StorageAccountInner>, StorageAccountInner> beginCreate(
        String resourceGroupName, String accountName, StorageAccountCreateParameters parameters);

    /**
     * Asynchronously creates a new storage account with the specified parameters. If an account is already created and
     * a subsequent create request is issued with different properties, the account properties will be updated. If an
     * account is already created and a subsequent create or update request is issued with the exact same set of
     * properties, the request will succeed.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters used when creating a storage account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<StorageAccountInner>, StorageAccountInner> beginCreate(
        String resourceGroupName, String accountName, StorageAccountCreateParameters parameters, Context context);

    /**
     * Asynchronously creates a new storage account with the specified parameters. If an account is already created and
     * a subsequent create request is issued with different properties, the account properties will be updated. If an
     * account is already created and a subsequent create or update request is issued with the exact same set of
     * properties, the request will succeed.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters used when creating a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageAccountInner> createAsync(
        String resourceGroupName, String accountName, StorageAccountCreateParameters parameters);

    /**
     * Asynchronously creates a new storage account with the specified parameters. If an account is already created and
     * a subsequent create request is issued with different properties, the account properties will be updated. If an
     * account is already created and a subsequent create or update request is issued with the exact same set of
     * properties, the request will succeed.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters used when creating a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageAccountInner create(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters);

    /**
     * Asynchronously creates a new storage account with the specified parameters. If an account is already created and
     * a subsequent create request is issued with different properties, the account properties will be updated. If an
     * account is already created and a subsequent create or update request is issued with the exact same set of
     * properties, the request will succeed.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters used when creating a storage account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageAccountInner create(
        String resourceGroupName, String accountName, StorageAccountCreateParameters parameters, Context context);

    /**
     * Deletes a storage account in Microsoft Azure.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName);

    /**
     * Deletes a storage account in Microsoft Azure.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String accountName);

    /**
     * Deletes a storage account in Microsoft Azure.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String accountName);

    /**
     * Deletes a storage account in Microsoft Azure.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String accountName, Context context);

    /**
     * Returns the properties for the specified storage account including but not limited to name, SKU name, location,
     * and account status. The ListKeys operation should be used to retrieve storage keys.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param expand May be used to expand the properties within account's properties. By default, data is not included
     *     when fetching properties. Currently we only support geoReplicationStats and blobRestoreStatus.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StorageAccountInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String accountName, StorageAccountExpand expand);

    /**
     * Returns the properties for the specified storage account including but not limited to name, SKU name, location,
     * and account status. The ListKeys operation should be used to retrieve storage keys.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param expand May be used to expand the properties within account's properties. By default, data is not included
     *     when fetching properties. Currently we only support geoReplicationStats and blobRestoreStatus.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageAccountInner> getByResourceGroupAsync(
        String resourceGroupName, String accountName, StorageAccountExpand expand);

    /**
     * Returns the properties for the specified storage account including but not limited to name, SKU name, location,
     * and account status. The ListKeys operation should be used to retrieve storage keys.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName);

    /**
     * Returns the properties for the specified storage account including but not limited to name, SKU name, location,
     * and account status. The ListKeys operation should be used to retrieve storage keys.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageAccountInner getByResourceGroup(String resourceGroupName, String accountName);

    /**
     * Returns the properties for the specified storage account including but not limited to name, SKU name, location,
     * and account status. The ListKeys operation should be used to retrieve storage keys.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param expand May be used to expand the properties within account's properties. By default, data is not included
     *     when fetching properties. Currently we only support geoReplicationStats and blobRestoreStatus.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StorageAccountInner> getByResourceGroupWithResponse(
        String resourceGroupName, String accountName, StorageAccountExpand expand, Context context);

    /**
     * The update operation can be used to update the SKU, encryption, access tier, or tags for a storage account. It
     * can also be used to map the account to a custom domain. Only one custom domain is supported per storage account;
     * the replacement/change of custom domain is not supported. In order to replace an old custom domain, the old value
     * must be cleared/unregistered before a new value can be set. The update of multiple properties is supported. This
     * call does not change the storage keys for the account. If you want to change the storage account keys, use the
     * regenerate keys operation. The location and name of the storage account cannot be changed after creation.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters that can be provided when updating the storage account properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StorageAccountInner>> updateWithResponseAsync(
        String resourceGroupName, String accountName, StorageAccountUpdateParameters parameters);

    /**
     * The update operation can be used to update the SKU, encryption, access tier, or tags for a storage account. It
     * can also be used to map the account to a custom domain. Only one custom domain is supported per storage account;
     * the replacement/change of custom domain is not supported. In order to replace an old custom domain, the old value
     * must be cleared/unregistered before a new value can be set. The update of multiple properties is supported. This
     * call does not change the storage keys for the account. If you want to change the storage account keys, use the
     * regenerate keys operation. The location and name of the storage account cannot be changed after creation.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters that can be provided when updating the storage account properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageAccountInner> updateAsync(
        String resourceGroupName, String accountName, StorageAccountUpdateParameters parameters);

    /**
     * The update operation can be used to update the SKU, encryption, access tier, or tags for a storage account. It
     * can also be used to map the account to a custom domain. Only one custom domain is supported per storage account;
     * the replacement/change of custom domain is not supported. In order to replace an old custom domain, the old value
     * must be cleared/unregistered before a new value can be set. The update of multiple properties is supported. This
     * call does not change the storage keys for the account. If you want to change the storage account keys, use the
     * regenerate keys operation. The location and name of the storage account cannot be changed after creation.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters that can be provided when updating the storage account properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageAccountInner update(String resourceGroupName, String accountName, StorageAccountUpdateParameters parameters);

    /**
     * The update operation can be used to update the SKU, encryption, access tier, or tags for a storage account. It
     * can also be used to map the account to a custom domain. Only one custom domain is supported per storage account;
     * the replacement/change of custom domain is not supported. In order to replace an old custom domain, the old value
     * must be cleared/unregistered before a new value can be set. The update of multiple properties is supported. This
     * call does not change the storage keys for the account. If you want to change the storage account keys, use the
     * regenerate keys operation. The location and name of the storage account cannot be changed after creation.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters that can be provided when updating the storage account properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the storage account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StorageAccountInner> updateWithResponse(
        String resourceGroupName, String accountName, StorageAccountUpdateParameters parameters, Context context);

    /**
     * Lists all the storage accounts available under the subscription. Note that storage keys are not returned; use the
     * ListKeys operation for this.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Storage Accounts operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StorageAccountInner> listAsync();

    /**
     * Lists all the storage accounts available under the subscription. Note that storage keys are not returned; use the
     * ListKeys operation for this.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Storage Accounts operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StorageAccountInner> list();

    /**
     * Lists all the storage accounts available under the subscription. Note that storage keys are not returned; use the
     * ListKeys operation for this.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Storage Accounts operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StorageAccountInner> list(Context context);

    /**
     * Lists all the storage accounts available under the given resource group. Note that storage keys are not returned;
     * use the ListKeys operation for this.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Storage Accounts operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StorageAccountInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists all the storage accounts available under the given resource group. Note that storage keys are not returned;
     * use the ListKeys operation for this.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Storage Accounts operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StorageAccountInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists all the storage accounts available under the given resource group. Note that storage keys are not returned;
     * use the ListKeys operation for this.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Storage Accounts operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StorageAccountInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Lists the access keys or Kerberos keys (if active directory enabled) for the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param expand Specifies type of the key to be listed. Possible value is kerb.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the ListKeys operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StorageAccountListKeysResultInner>> listKeysWithResponseAsync(
        String resourceGroupName, String accountName, ListKeyExpand expand);

    /**
     * Lists the access keys or Kerberos keys (if active directory enabled) for the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param expand Specifies type of the key to be listed. Possible value is kerb.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the ListKeys operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageAccountListKeysResultInner> listKeysAsync(
        String resourceGroupName, String accountName, ListKeyExpand expand);

    /**
     * Lists the access keys or Kerberos keys (if active directory enabled) for the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the ListKeys operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName);

    /**
     * Lists the access keys or Kerberos keys (if active directory enabled) for the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the ListKeys operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageAccountListKeysResultInner listKeys(String resourceGroupName, String accountName);

    /**
     * Lists the access keys or Kerberos keys (if active directory enabled) for the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param expand Specifies type of the key to be listed. Possible value is kerb.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the ListKeys operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StorageAccountListKeysResultInner> listKeysWithResponse(
        String resourceGroupName, String accountName, ListKeyExpand expand, Context context);

    /**
     * Regenerates one of the access keys or Kerberos keys for the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param keyName The name of storage keys that want to be regenerated, possible values are key1, key2, kerb1,
     *     kerb2.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the ListKeys operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StorageAccountListKeysResultInner>> regenerateKeyWithResponseAsync(
        String resourceGroupName, String accountName, String keyName);

    /**
     * Regenerates one of the access keys or Kerberos keys for the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param keyName The name of storage keys that want to be regenerated, possible values are key1, key2, kerb1,
     *     kerb2.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the ListKeys operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageAccountListKeysResultInner> regenerateKeyAsync(
        String resourceGroupName, String accountName, String keyName);

    /**
     * Regenerates one of the access keys or Kerberos keys for the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param keyName The name of storage keys that want to be regenerated, possible values are key1, key2, kerb1,
     *     kerb2.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the ListKeys operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageAccountListKeysResultInner regenerateKey(String resourceGroupName, String accountName, String keyName);

    /**
     * Regenerates one of the access keys or Kerberos keys for the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param keyName The name of storage keys that want to be regenerated, possible values are key1, key2, kerb1,
     *     kerb2.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the ListKeys operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StorageAccountListKeysResultInner> regenerateKeyWithResponse(
        String resourceGroupName, String accountName, String keyName, Context context);

    /**
     * List SAS credentials of a storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters to list SAS credentials of a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List SAS credentials operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ListAccountSasResponseInner>> listAccountSasWithResponseAsync(
        String resourceGroupName, String accountName, AccountSasParameters parameters);

    /**
     * List SAS credentials of a storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters to list SAS credentials of a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List SAS credentials operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ListAccountSasResponseInner> listAccountSasAsync(
        String resourceGroupName, String accountName, AccountSasParameters parameters);

    /**
     * List SAS credentials of a storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters to list SAS credentials of a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List SAS credentials operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ListAccountSasResponseInner listAccountSas(
        String resourceGroupName, String accountName, AccountSasParameters parameters);

    /**
     * List SAS credentials of a storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters to list SAS credentials of a storage account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List SAS credentials operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ListAccountSasResponseInner> listAccountSasWithResponse(
        String resourceGroupName, String accountName, AccountSasParameters parameters, Context context);

    /**
     * List service SAS credentials of a specific resource.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters to list service SAS credentials of a specific resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List service SAS credentials operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ListServiceSasResponseInner>> listServiceSasWithResponseAsync(
        String resourceGroupName, String accountName, ServiceSasParameters parameters);

    /**
     * List service SAS credentials of a specific resource.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters to list service SAS credentials of a specific resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List service SAS credentials operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ListServiceSasResponseInner> listServiceSasAsync(
        String resourceGroupName, String accountName, ServiceSasParameters parameters);

    /**
     * List service SAS credentials of a specific resource.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters to list service SAS credentials of a specific resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List service SAS credentials operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ListServiceSasResponseInner listServiceSas(
        String resourceGroupName, String accountName, ServiceSasParameters parameters);

    /**
     * List service SAS credentials of a specific resource.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param parameters The parameters to list service SAS credentials of a specific resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List service SAS credentials operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ListServiceSasResponseInner> listServiceSasWithResponse(
        String resourceGroupName, String accountName, ServiceSasParameters parameters, Context context);

    /**
     * Failover request can be triggered for a storage account in case of availability issues. The failover occurs from
     * the storage account's primary cluster to secondary cluster for RA-GRS accounts. The secondary cluster will become
     * primary after failover.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> failoverWithResponseAsync(String resourceGroupName, String accountName);

    /**
     * Failover request can be triggered for a storage account in case of availability issues. The failover occurs from
     * the storage account's primary cluster to secondary cluster for RA-GRS accounts. The secondary cluster will become
     * primary after failover.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginFailoverAsync(String resourceGroupName, String accountName);

    /**
     * Failover request can be triggered for a storage account in case of availability issues. The failover occurs from
     * the storage account's primary cluster to secondary cluster for RA-GRS accounts. The secondary cluster will become
     * primary after failover.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginFailover(String resourceGroupName, String accountName);

    /**
     * Failover request can be triggered for a storage account in case of availability issues. The failover occurs from
     * the storage account's primary cluster to secondary cluster for RA-GRS accounts. The secondary cluster will become
     * primary after failover.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginFailover(String resourceGroupName, String accountName, Context context);

    /**
     * Failover request can be triggered for a storage account in case of availability issues. The failover occurs from
     * the storage account's primary cluster to secondary cluster for RA-GRS accounts. The secondary cluster will become
     * primary after failover.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> failoverAsync(String resourceGroupName, String accountName);

    /**
     * Failover request can be triggered for a storage account in case of availability issues. The failover occurs from
     * the storage account's primary cluster to secondary cluster for RA-GRS accounts. The secondary cluster will become
     * primary after failover.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void failover(String resourceGroupName, String accountName);

    /**
     * Failover request can be triggered for a storage account in case of availability issues. The failover occurs from
     * the storage account's primary cluster to secondary cluster for RA-GRS accounts. The secondary cluster will become
     * primary after failover.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void failover(String resourceGroupName, String accountName, Context context);

    /**
     * Restore blobs in the specified blob ranges.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param timeToRestore Restore blob to the specified time.
     * @param blobRanges Blob ranges to restore.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return blob restore status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> restoreBlobRangesWithResponseAsync(
        String resourceGroupName, String accountName, OffsetDateTime timeToRestore, List<BlobRestoreRange> blobRanges);

    /**
     * Restore blobs in the specified blob ranges.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param timeToRestore Restore blob to the specified time.
     * @param blobRanges Blob ranges to restore.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return blob restore status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<BlobRestoreStatusInner>, BlobRestoreStatusInner> beginRestoreBlobRangesAsync(
        String resourceGroupName, String accountName, OffsetDateTime timeToRestore, List<BlobRestoreRange> blobRanges);

    /**
     * Restore blobs in the specified blob ranges.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param timeToRestore Restore blob to the specified time.
     * @param blobRanges Blob ranges to restore.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return blob restore status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<BlobRestoreStatusInner>, BlobRestoreStatusInner> beginRestoreBlobRanges(
        String resourceGroupName, String accountName, OffsetDateTime timeToRestore, List<BlobRestoreRange> blobRanges);

    /**
     * Restore blobs in the specified blob ranges.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param timeToRestore Restore blob to the specified time.
     * @param blobRanges Blob ranges to restore.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return blob restore status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<BlobRestoreStatusInner>, BlobRestoreStatusInner> beginRestoreBlobRanges(
        String resourceGroupName,
        String accountName,
        OffsetDateTime timeToRestore,
        List<BlobRestoreRange> blobRanges,
        Context context);

    /**
     * Restore blobs in the specified blob ranges.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param timeToRestore Restore blob to the specified time.
     * @param blobRanges Blob ranges to restore.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return blob restore status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BlobRestoreStatusInner> restoreBlobRangesAsync(
        String resourceGroupName, String accountName, OffsetDateTime timeToRestore, List<BlobRestoreRange> blobRanges);

    /**
     * Restore blobs in the specified blob ranges.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param timeToRestore Restore blob to the specified time.
     * @param blobRanges Blob ranges to restore.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return blob restore status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BlobRestoreStatusInner restoreBlobRanges(
        String resourceGroupName, String accountName, OffsetDateTime timeToRestore, List<BlobRestoreRange> blobRanges);

    /**
     * Restore blobs in the specified blob ranges.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param timeToRestore Restore blob to the specified time.
     * @param blobRanges Blob ranges to restore.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return blob restore status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BlobRestoreStatusInner restoreBlobRanges(
        String resourceGroupName,
        String accountName,
        OffsetDateTime timeToRestore,
        List<BlobRestoreRange> blobRanges,
        Context context);

    /**
     * Revoke user delegation keys.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> revokeUserDelegationKeysWithResponseAsync(String resourceGroupName, String accountName);

    /**
     * Revoke user delegation keys.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> revokeUserDelegationKeysAsync(String resourceGroupName, String accountName);

    /**
     * Revoke user delegation keys.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void revokeUserDelegationKeys(String resourceGroupName, String accountName);

    /**
     * Revoke user delegation keys.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> revokeUserDelegationKeysWithResponse(String resourceGroupName, String accountName, Context context);
}
