// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Object to define the number of days after last modification. */
@Fluent
public final class DateAfterModification {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DateAfterModification.class);

    /*
     * Value indicating the age in days after last modification
     */
    @JsonProperty(value = "daysAfterModificationGreaterThan", required = true)
    private float daysAfterModificationGreaterThan;

    /**
     * Get the daysAfterModificationGreaterThan property: Value indicating the age in days after last modification.
     *
     * @return the daysAfterModificationGreaterThan value.
     */
    public float daysAfterModificationGreaterThan() {
        return this.daysAfterModificationGreaterThan;
    }

    /**
     * Set the daysAfterModificationGreaterThan property: Value indicating the age in days after last modification.
     *
     * @param daysAfterModificationGreaterThan the daysAfterModificationGreaterThan value to set.
     * @return the DateAfterModification object itself.
     */
    public DateAfterModification withDaysAfterModificationGreaterThan(float daysAfterModificationGreaterThan) {
        this.daysAfterModificationGreaterThan = daysAfterModificationGreaterThan;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
