/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.AzureEntityResource;
import com.azure.resourcemanager.storage.models.EnabledProtocols;
import com.azure.resourcemanager.storage.models.RootSquashType;
import com.azure.resourcemanager.storage.models.ShareAccessTier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

@JsonFlatten
public class FileShareInner
extends AzureEntityResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FileShareInner.class);
    @JsonProperty(value="properties.lastModifiedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedTime;
    @JsonProperty(value="properties.metadata")
    private Map<String, String> metadata;
    @JsonProperty(value="properties.shareQuota")
    private Integer shareQuota;
    @JsonProperty(value="properties.enabledProtocols")
    private EnabledProtocols enabledProtocols;
    @JsonProperty(value="properties.rootSquash")
    private RootSquashType rootSquash;
    @JsonProperty(value="properties.version", access=JsonProperty.Access.WRITE_ONLY)
    private String version;
    @JsonProperty(value="properties.deleted", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean deleted;
    @JsonProperty(value="properties.deletedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime deletedTime;
    @JsonProperty(value="properties.remainingRetentionDays", access=JsonProperty.Access.WRITE_ONLY)
    private Integer remainingRetentionDays;
    @JsonProperty(value="properties.accessTier")
    private ShareAccessTier accessTier;
    @JsonProperty(value="properties.accessTierChangeTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime accessTierChangeTime;
    @JsonProperty(value="properties.accessTierStatus", access=JsonProperty.Access.WRITE_ONLY)
    private String accessTierStatus;
    @JsonProperty(value="properties.shareUsageBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long shareUsageBytes;

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public FileShareInner withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer shareQuota() {
        return this.shareQuota;
    }

    public FileShareInner withShareQuota(Integer shareQuota) {
        this.shareQuota = shareQuota;
        return this;
    }

    public EnabledProtocols enabledProtocols() {
        return this.enabledProtocols;
    }

    public FileShareInner withEnabledProtocols(EnabledProtocols enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public RootSquashType rootSquash() {
        return this.rootSquash;
    }

    public FileShareInner withRootSquash(RootSquashType rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    public String version() {
        return this.version;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public OffsetDateTime deletedTime() {
        return this.deletedTime;
    }

    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public ShareAccessTier accessTier() {
        return this.accessTier;
    }

    public FileShareInner withAccessTier(ShareAccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public OffsetDateTime accessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    public String accessTierStatus() {
        return this.accessTierStatus;
    }

    public Long shareUsageBytes() {
        return this.shareUsageBytes;
    }

    @Override
    public void validate() {
        super.validate();
    }
}

