/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storage.fluent.BlobContainersClient;
import com.azure.resourcemanager.storage.fluent.models.BlobContainerInner;
import com.azure.resourcemanager.storage.fluent.models.ImmutabilityPolicyInner;
import com.azure.resourcemanager.storage.fluent.models.LeaseContainerResponseInner;
import com.azure.resourcemanager.storage.fluent.models.LegalHoldInner;
import com.azure.resourcemanager.storage.fluent.models.ListContainerItemInner;
import com.azure.resourcemanager.storage.implementation.StorageManagementClientImpl;
import com.azure.resourcemanager.storage.models.BlobContainersCreateOrUpdateImmutabilityPolicyResponse;
import com.azure.resourcemanager.storage.models.BlobContainersDeleteImmutabilityPolicyResponse;
import com.azure.resourcemanager.storage.models.BlobContainersExtendImmutabilityPolicyResponse;
import com.azure.resourcemanager.storage.models.BlobContainersGetImmutabilityPolicyResponse;
import com.azure.resourcemanager.storage.models.BlobContainersLockImmutabilityPolicyResponse;
import com.azure.resourcemanager.storage.models.LeaseContainerRequest;
import com.azure.resourcemanager.storage.models.ListContainerItems;
import com.azure.resourcemanager.storage.models.ListContainersInclude;
import java.util.List;
import reactor.core.publisher.Mono;

public final class BlobContainersClientImpl
implements BlobContainersClient {
    private final ClientLogger logger = new ClientLogger(BlobContainersClientImpl.class);
    private final BlobContainersService service;
    private final StorageManagementClientImpl client;

    BlobContainersClientImpl(StorageManagementClientImpl client) {
        this.service = (BlobContainersService)RestProxy.create(BlobContainersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<ListContainerItemInner>> listSinglePageAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListContainersInclude include) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), maxpagesize, filter, include, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListContainerItems)res.getValue()).value(), ((ListContainerItems)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ListContainerItemInner>> listSinglePageAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListContainersInclude include, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), maxpagesize, filter, include, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListContainerItems)res.getValue()).value(), ((ListContainerItems)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ListContainerItemInner> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListContainersInclude include) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, include), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ListContainerItemInner> listAsync(String resourceGroupName, String accountName) {
        String maxpagesize = null;
        String filter = null;
        ListContainersInclude include = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, include), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ListContainerItemInner> listAsync(String resourceGroupName, String accountName, String maxpagesize, String filter, ListContainersInclude include, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, include, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ListContainerItemInner> list(String resourceGroupName, String accountName, String maxpagesize, String filter, ListContainersInclude include, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, accountName, maxpagesize, filter, include, context));
    }

    @Override
    public PagedIterable<ListContainerItemInner> list(String resourceGroupName, String accountName) {
        String maxpagesize = null;
        String filter = null;
        ListContainersInclude include = null;
        return new PagedIterable(this.listAsync(resourceGroupName, accountName, maxpagesize, filter, include));
    }

    @Override
    public Mono<Response<BlobContainerInner>> createWithResponseAsync(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobContainer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobContainer is required and cannot be null."));
        }
        blobContainer.validate();
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobContainer, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<BlobContainerInner>> createWithResponseAsync(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobContainer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobContainer is required and cannot be null."));
        }
        blobContainer.validate();
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobContainer, context);
    }

    @Override
    public Mono<BlobContainerInner> createAsync(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer) {
        return this.createWithResponseAsync(resourceGroupName, accountName, containerName, blobContainer).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BlobContainerInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public BlobContainerInner create(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer) {
        return (BlobContainerInner)((Object)this.createAsync(resourceGroupName, accountName, containerName, blobContainer).block());
    }

    @Override
    public Response<BlobContainerInner> createWithResponse(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, accountName, containerName, blobContainer, context).block();
    }

    @Override
    public Mono<Response<BlobContainerInner>> updateWithResponseAsync(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobContainer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobContainer is required and cannot be null."));
        }
        blobContainer.validate();
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobContainer, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<BlobContainerInner>> updateWithResponseAsync(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (blobContainer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter blobContainer is required and cannot be null."));
        }
        blobContainer.validate();
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), blobContainer, context);
    }

    @Override
    public Mono<BlobContainerInner> updateAsync(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer) {
        return this.updateWithResponseAsync(resourceGroupName, accountName, containerName, blobContainer).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BlobContainerInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public BlobContainerInner update(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer) {
        return (BlobContainerInner)((Object)this.updateAsync(resourceGroupName, accountName, containerName, blobContainer).block());
    }

    @Override
    public Response<BlobContainerInner> updateWithResponse(String resourceGroupName, String accountName, String containerName, BlobContainerInner blobContainer, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, accountName, containerName, blobContainer, context).block();
    }

    @Override
    public Mono<Response<BlobContainerInner>> getWithResponseAsync(String resourceGroupName, String accountName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<BlobContainerInner>> getWithResponseAsync(String resourceGroupName, String accountName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<BlobContainerInner> getAsync(String resourceGroupName, String accountName, String containerName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, containerName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BlobContainerInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public BlobContainerInner get(String resourceGroupName, String accountName, String containerName) {
        return (BlobContainerInner)((Object)this.getAsync(resourceGroupName, accountName, containerName).block());
    }

    @Override
    public Response<BlobContainerInner> getWithResponse(String resourceGroupName, String accountName, String containerName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, accountName, containerName, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String accountName, String containerName) {
        return this.deleteWithResponseAsync(resourceGroupName, accountName, containerName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String containerName) {
        this.deleteAsync(resourceGroupName, accountName, containerName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String accountName, String containerName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, accountName, containerName, context).block();
    }

    @Override
    public Mono<Response<LegalHoldInner>> setLegalHoldWithResponseAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tags == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tags is required and cannot be null."));
        }
        LegalHoldInner legalHold = new LegalHoldInner();
        legalHold.withTags(tags);
        return FluxUtil.withContext(context -> this.service.setLegalHold(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), legalHold, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<LegalHoldInner>> setLegalHoldWithResponseAsync(String resourceGroupName, String accountName, String containerName, List<String> tags, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tags == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tags is required and cannot be null."));
        }
        LegalHoldInner legalHold = new LegalHoldInner();
        legalHold.withTags(tags);
        context = this.client.mergeContext(context);
        return this.service.setLegalHold(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), legalHold, context);
    }

    @Override
    public Mono<LegalHoldInner> setLegalHoldAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        return this.setLegalHoldWithResponseAsync(resourceGroupName, accountName, containerName, tags).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LegalHoldInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public LegalHoldInner setLegalHold(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        return (LegalHoldInner)this.setLegalHoldAsync(resourceGroupName, accountName, containerName, tags).block();
    }

    @Override
    public Response<LegalHoldInner> setLegalHoldWithResponse(String resourceGroupName, String accountName, String containerName, List<String> tags, Context context) {
        return (Response)this.setLegalHoldWithResponseAsync(resourceGroupName, accountName, containerName, tags, context).block();
    }

    @Override
    public Mono<Response<LegalHoldInner>> clearLegalHoldWithResponseAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tags == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tags is required and cannot be null."));
        }
        LegalHoldInner legalHold = new LegalHoldInner();
        legalHold.withTags(tags);
        return FluxUtil.withContext(context -> this.service.clearLegalHold(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), legalHold, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<LegalHoldInner>> clearLegalHoldWithResponseAsync(String resourceGroupName, String accountName, String containerName, List<String> tags, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tags == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tags is required and cannot be null."));
        }
        LegalHoldInner legalHold = new LegalHoldInner();
        legalHold.withTags(tags);
        context = this.client.mergeContext(context);
        return this.service.clearLegalHold(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), legalHold, context);
    }

    @Override
    public Mono<LegalHoldInner> clearLegalHoldAsync(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        return this.clearLegalHoldWithResponseAsync(resourceGroupName, accountName, containerName, tags).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LegalHoldInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public LegalHoldInner clearLegalHold(String resourceGroupName, String accountName, String containerName, List<String> tags) {
        return (LegalHoldInner)this.clearLegalHoldAsync(resourceGroupName, accountName, containerName, tags).block();
    }

    @Override
    public Response<LegalHoldInner> clearLegalHoldWithResponse(String resourceGroupName, String accountName, String containerName, List<String> tags, Context context) {
        return (Response)this.clearLegalHoldWithResponseAsync(resourceGroupName, accountName, containerName, tags, context).block();
    }

    @Override
    public Mono<BlobContainersCreateOrUpdateImmutabilityPolicyResponse> createOrUpdateImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, Integer immutabilityPeriodSinceCreationInDays, Boolean allowProtectedAppendWrites) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String immutabilityPolicyName = "default";
        ImmutabilityPolicyInner parametersInternal = null;
        if (immutabilityPeriodSinceCreationInDays != null || allowProtectedAppendWrites != null) {
            parametersInternal = new ImmutabilityPolicyInner();
            parametersInternal.withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
            parametersInternal.withAllowProtectedAppendWrites(allowProtectedAppendWrites);
        }
        ImmutabilityPolicyInner parameters = parametersInternal;
        return FluxUtil.withContext(context -> this.service.createOrUpdateImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, "default", this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<BlobContainersCreateOrUpdateImmutabilityPolicyResponse> createOrUpdateImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, Integer immutabilityPeriodSinceCreationInDays, Boolean allowProtectedAppendWrites, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String immutabilityPolicyName = "default";
        ImmutabilityPolicyInner parametersInternal = null;
        if (immutabilityPeriodSinceCreationInDays != null || allowProtectedAppendWrites != null) {
            parametersInternal = new ImmutabilityPolicyInner();
            parametersInternal.withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
            parametersInternal.withAllowProtectedAppendWrites(allowProtectedAppendWrites);
        }
        ImmutabilityPolicyInner parameters = parametersInternal;
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, "default", this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, parameters, context);
    }

    @Override
    public Mono<ImmutabilityPolicyInner> createOrUpdateImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, Integer immutabilityPeriodSinceCreationInDays, Boolean allowProtectedAppendWrites) {
        return this.createOrUpdateImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays, allowProtectedAppendWrites).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ImmutabilityPolicyInner> createOrUpdateImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName) {
        String ifMatch = null;
        Integer immutabilityPeriodSinceCreationInDays = null;
        Boolean allowProtectedAppendWrites = null;
        return this.createOrUpdateImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays, allowProtectedAppendWrites).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ImmutabilityPolicyInner createOrUpdateImmutabilityPolicy(String resourceGroupName, String accountName, String containerName) {
        String ifMatch = null;
        Integer immutabilityPeriodSinceCreationInDays = null;
        Boolean allowProtectedAppendWrites = null;
        return (ImmutabilityPolicyInner)((Object)this.createOrUpdateImmutabilityPolicyAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays, allowProtectedAppendWrites).block());
    }

    @Override
    public Response<ImmutabilityPolicyInner> createOrUpdateImmutabilityPolicyWithResponse(String resourceGroupName, String accountName, String containerName, String ifMatch, Integer immutabilityPeriodSinceCreationInDays, Boolean allowProtectedAppendWrites, Context context) {
        return (Response)this.createOrUpdateImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays, allowProtectedAppendWrites, context).block();
    }

    @Override
    public Mono<BlobContainersGetImmutabilityPolicyResponse> getImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String immutabilityPolicyName = "default";
        return FluxUtil.withContext(context -> this.service.getImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, "default", this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<BlobContainersGetImmutabilityPolicyResponse> getImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String immutabilityPolicyName = "default";
        context = this.client.mergeContext(context);
        return this.service.getImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, "default", this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, context);
    }

    @Override
    public Mono<ImmutabilityPolicyInner> getImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return this.getImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ImmutabilityPolicyInner> getImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName) {
        String ifMatch = null;
        return this.getImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ImmutabilityPolicyInner getImmutabilityPolicy(String resourceGroupName, String accountName, String containerName) {
        String ifMatch = null;
        return (ImmutabilityPolicyInner)((Object)this.getImmutabilityPolicyAsync(resourceGroupName, accountName, containerName, ifMatch).block());
    }

    @Override
    public Response<ImmutabilityPolicyInner> getImmutabilityPolicyWithResponse(String resourceGroupName, String accountName, String containerName, String ifMatch, Context context) {
        return (Response)this.getImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch, context).block();
    }

    @Override
    public Mono<BlobContainersDeleteImmutabilityPolicyResponse> deleteImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        String immutabilityPolicyName = "default";
        return FluxUtil.withContext(context -> this.service.deleteImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, "default", this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<BlobContainersDeleteImmutabilityPolicyResponse> deleteImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        String immutabilityPolicyName = "default";
        context = this.client.mergeContext(context);
        return this.service.deleteImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, "default", this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, context);
    }

    @Override
    public Mono<ImmutabilityPolicyInner> deleteImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return this.deleteImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ImmutabilityPolicyInner deleteImmutabilityPolicy(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return (ImmutabilityPolicyInner)((Object)this.deleteImmutabilityPolicyAsync(resourceGroupName, accountName, containerName, ifMatch).block());
    }

    @Override
    public Response<ImmutabilityPolicyInner> deleteImmutabilityPolicyWithResponse(String resourceGroupName, String accountName, String containerName, String ifMatch, Context context) {
        return (Response)this.deleteImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch, context).block();
    }

    @Override
    public Mono<BlobContainersLockImmutabilityPolicyResponse> lockImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.lockImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<BlobContainersLockImmutabilityPolicyResponse> lockImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.lockImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, context);
    }

    @Override
    public Mono<ImmutabilityPolicyInner> lockImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return this.lockImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ImmutabilityPolicyInner lockImmutabilityPolicy(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        return (ImmutabilityPolicyInner)((Object)this.lockImmutabilityPolicyAsync(resourceGroupName, accountName, containerName, ifMatch).block());
    }

    @Override
    public Response<ImmutabilityPolicyInner> lockImmutabilityPolicyWithResponse(String resourceGroupName, String accountName, String containerName, String ifMatch, Context context) {
        return (Response)this.lockImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch, context).block();
    }

    @Override
    public Mono<BlobContainersExtendImmutabilityPolicyResponse> extendImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, Integer immutabilityPeriodSinceCreationInDays, Boolean allowProtectedAppendWrites) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        ImmutabilityPolicyInner parametersInternal = null;
        if (immutabilityPeriodSinceCreationInDays != null || allowProtectedAppendWrites != null) {
            parametersInternal = new ImmutabilityPolicyInner();
            parametersInternal.withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
            parametersInternal.withAllowProtectedAppendWrites(allowProtectedAppendWrites);
        }
        ImmutabilityPolicyInner parameters = parametersInternal;
        return FluxUtil.withContext(context -> this.service.extendImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<BlobContainersExtendImmutabilityPolicyResponse> extendImmutabilityPolicyWithResponseAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, Integer immutabilityPeriodSinceCreationInDays, Boolean allowProtectedAppendWrites, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        ImmutabilityPolicyInner parametersInternal = null;
        if (immutabilityPeriodSinceCreationInDays != null || allowProtectedAppendWrites != null) {
            parametersInternal = new ImmutabilityPolicyInner();
            parametersInternal.withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
            parametersInternal.withAllowProtectedAppendWrites(allowProtectedAppendWrites);
        }
        ImmutabilityPolicyInner parameters = parametersInternal;
        context = this.client.mergeContext(context);
        return this.service.extendImmutabilityPolicy(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), ifMatch, parameters, context);
    }

    @Override
    public Mono<ImmutabilityPolicyInner> extendImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch, Integer immutabilityPeriodSinceCreationInDays, Boolean allowProtectedAppendWrites) {
        return this.extendImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays, allowProtectedAppendWrites).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ImmutabilityPolicyInner> extendImmutabilityPolicyAsync(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        Integer immutabilityPeriodSinceCreationInDays = null;
        Boolean allowProtectedAppendWrites = null;
        return this.extendImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays, allowProtectedAppendWrites).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ImmutabilityPolicyInner extendImmutabilityPolicy(String resourceGroupName, String accountName, String containerName, String ifMatch) {
        Integer immutabilityPeriodSinceCreationInDays = null;
        Boolean allowProtectedAppendWrites = null;
        return (ImmutabilityPolicyInner)((Object)this.extendImmutabilityPolicyAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays, allowProtectedAppendWrites).block());
    }

    @Override
    public Response<ImmutabilityPolicyInner> extendImmutabilityPolicyWithResponse(String resourceGroupName, String accountName, String containerName, String ifMatch, Integer immutabilityPeriodSinceCreationInDays, Boolean allowProtectedAppendWrites, Context context) {
        return (Response)this.extendImmutabilityPolicyWithResponseAsync(resourceGroupName, accountName, containerName, ifMatch, immutabilityPeriodSinceCreationInDays, allowProtectedAppendWrites, context).block();
    }

    @Override
    public Mono<Response<LeaseContainerResponseInner>> leaseWithResponseAsync(String resourceGroupName, String accountName, String containerName, LeaseContainerRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        return FluxUtil.withContext(context -> this.service.lease(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<LeaseContainerResponseInner>> leaseWithResponseAsync(String resourceGroupName, String accountName, String containerName, LeaseContainerRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return this.service.lease(this.client.getEndpoint(), resourceGroupName, accountName, containerName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<LeaseContainerResponseInner> leaseAsync(String resourceGroupName, String accountName, String containerName, LeaseContainerRequest parameters) {
        return this.leaseWithResponseAsync(resourceGroupName, accountName, containerName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LeaseContainerResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<LeaseContainerResponseInner> leaseAsync(String resourceGroupName, String accountName, String containerName) {
        LeaseContainerRequest parameters = null;
        return this.leaseWithResponseAsync(resourceGroupName, accountName, containerName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LeaseContainerResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public LeaseContainerResponseInner lease(String resourceGroupName, String accountName, String containerName) {
        LeaseContainerRequest parameters = null;
        return (LeaseContainerResponseInner)this.leaseAsync(resourceGroupName, accountName, containerName, parameters).block();
    }

    @Override
    public Response<LeaseContainerResponseInner> leaseWithResponse(String resourceGroupName, String accountName, String containerName, LeaseContainerRequest parameters, Context context) {
        return (Response)this.leaseWithResponseAsync(resourceGroupName, accountName, containerName, parameters, context).block();
    }

    private Mono<PagedResponse<ListContainerItemInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListContainerItems)res.getValue()).value(), ((ListContainerItems)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ListContainerItemInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListContainerItems)res.getValue()).value(), ((ListContainerItems)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageManagementCli")
    private static interface BlobContainersService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListContainerItems>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="$maxpagesize") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$include") ListContainersInclude var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BlobContainerInner>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") BlobContainerInner var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BlobContainerInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") BlobContainerInner var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BlobContainerInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/setLegalHold")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LegalHoldInner>> setLegalHold(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") LegalHoldInner var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/clearLegalHold")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LegalHoldInner>> clearLegalHold(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") LegalHoldInner var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<BlobContainersCreateOrUpdateImmutabilityPolicyResponse> createOrUpdateImmutabilityPolicy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @PathParam(value="immutabilityPolicyName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="If-Match") String var8, @BodyParam(value="application/json") ImmutabilityPolicyInner var9, Context var10);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<BlobContainersGetImmutabilityPolicyResponse> getImmutabilityPolicy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @PathParam(value="immutabilityPolicyName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="If-Match") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<BlobContainersDeleteImmutabilityPolicyResponse> deleteImmutabilityPolicy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @PathParam(value="immutabilityPolicyName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="If-Match") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/lock")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<BlobContainersLockImmutabilityPolicyResponse> lockImmutabilityPolicy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="If-Match") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/default/extend")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<BlobContainersExtendImmutabilityPolicyResponse> extendImmutabilityPolicy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="If-Match") String var7, @BodyParam(value="application/json") ImmutabilityPolicyInner var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/lease")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LeaseContainerResponseInner>> lease(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @PathParam(value="containerName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") LeaseContainerRequest var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListContainerItems>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

