/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storage.fluent.ManagementPoliciesClient;
import com.azure.resourcemanager.storage.fluent.models.ManagementPolicyInner;
import com.azure.resourcemanager.storage.implementation.StorageManagementClientImpl;
import com.azure.resourcemanager.storage.models.ManagementPolicyName;
import com.azure.resourcemanager.storage.models.ManagementPolicySchema;
import reactor.core.publisher.Mono;

public final class ManagementPoliciesClientImpl
implements ManagementPoliciesClient {
    private final ClientLogger logger = new ClientLogger(ManagementPoliciesClientImpl.class);
    private final ManagementPoliciesService service;
    private final StorageManagementClientImpl client;

    ManagementPoliciesClientImpl(StorageManagementClientImpl client) {
        this.service = (ManagementPoliciesService)RestProxy.create(ManagementPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ManagementPolicyInner>> getWithResponseAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (managementPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementPolicyName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), managementPolicyName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ManagementPolicyInner>> getWithResponseAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (managementPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementPolicyName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), managementPolicyName, context);
    }

    @Override
    public Mono<ManagementPolicyInner> getAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, managementPolicyName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ManagementPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ManagementPolicyInner get(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName) {
        return (ManagementPolicyInner)((Object)this.getAsync(resourceGroupName, accountName, managementPolicyName).block());
    }

    @Override
    public Response<ManagementPolicyInner> getWithResponse(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, accountName, managementPolicyName, context).block();
    }

    @Override
    public Mono<Response<ManagementPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName, ManagementPolicySchema policy) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (managementPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementPolicyName is required and cannot be null."));
        }
        if (policy != null) {
            policy.validate();
        }
        ManagementPolicyInner properties = new ManagementPolicyInner();
        properties.withPolicy(policy);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), managementPolicyName, properties, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ManagementPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName, ManagementPolicySchema policy, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (managementPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementPolicyName is required and cannot be null."));
        }
        if (policy != null) {
            policy.validate();
        }
        ManagementPolicyInner properties = new ManagementPolicyInner();
        properties.withPolicy(policy);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), managementPolicyName, properties, context);
    }

    @Override
    public Mono<ManagementPolicyInner> createOrUpdateAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName, ManagementPolicySchema policy) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, managementPolicyName, policy).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ManagementPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ManagementPolicyInner> createOrUpdateAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName) {
        ManagementPolicySchema policy = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, managementPolicyName, policy).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ManagementPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ManagementPolicyInner createOrUpdate(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName) {
        ManagementPolicySchema policy = null;
        return (ManagementPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, accountName, managementPolicyName, policy).block());
    }

    @Override
    public Response<ManagementPolicyInner> createOrUpdateWithResponse(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName, ManagementPolicySchema policy, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, accountName, managementPolicyName, policy, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (managementPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementPolicyName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), managementPolicyName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (managementPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementPolicyName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, accountName, this.client.getApiVersion(), this.client.getSubscriptionId(), managementPolicyName, context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName) {
        return this.deleteWithResponseAsync(resourceGroupName, accountName, managementPolicyName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName) {
        this.deleteAsync(resourceGroupName, accountName, managementPolicyName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String accountName, ManagementPolicyName managementPolicyName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, accountName, managementPolicyName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageManagementCli")
    private static interface ManagementPoliciesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/managementPolicies/{managementPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagementPolicyInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="managementPolicyName") ManagementPolicyName var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/managementPolicies/{managementPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagementPolicyInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="managementPolicyName") ManagementPolicyName var6, @BodyParam(value="application/json") ManagementPolicyInner var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/managementPolicies/{managementPolicyName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="accountName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="managementPolicyName") ManagementPolicyName var6, Context var7);
    }
}

