/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.fluent.SkusClient;
import com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.azure.resourcemanager.storage.implementation.StorageSkuImpl;
import com.azure.resourcemanager.storage.models.StorageSku;
import com.azure.resourcemanager.storage.models.StorageSkus;

public class StorageSkusImpl
implements StorageSkus {
    private final StorageManager manager;

    public StorageSkusImpl(StorageManager storageManager) {
        this.manager = storageManager;
    }

    public StorageManager manager() {
        return this.manager;
    }

    public PagedIterable<StorageSku> list() {
        return this.inner().list().mapPage(StorageSkuImpl::new);
    }

    public PagedFlux<StorageSku> listAsync() {
        return this.inner().listAsync().mapPage(StorageSkuImpl::new);
    }

    public SkusClient inner() {
        return ((StorageManagementClient)this.manager.serviceClient()).getSkus();
    }
}

