/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.ActiveDirectoryProperties;
import com.azure.resourcemanager.storage.models.DirectoryServiceOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AzureFilesIdentityBasedAuthentication {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureFilesIdentityBasedAuthentication.class);
    @JsonProperty(value="directoryServiceOptions", required=true)
    private DirectoryServiceOptions directoryServiceOptions;
    @JsonProperty(value="activeDirectoryProperties")
    private ActiveDirectoryProperties activeDirectoryProperties;

    public DirectoryServiceOptions directoryServiceOptions() {
        return this.directoryServiceOptions;
    }

    public AzureFilesIdentityBasedAuthentication withDirectoryServiceOptions(DirectoryServiceOptions directoryServiceOptions) {
        this.directoryServiceOptions = directoryServiceOptions;
        return this;
    }

    public ActiveDirectoryProperties activeDirectoryProperties() {
        return this.activeDirectoryProperties;
    }

    public AzureFilesIdentityBasedAuthentication withActiveDirectoryProperties(ActiveDirectoryProperties activeDirectoryProperties) {
        this.activeDirectoryProperties = activeDirectoryProperties;
        return this;
    }

    public void validate() {
        if (this.directoryServiceOptions() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property directoryServiceOptions in model AzureFilesIdentityBasedAuthentication"));
        }
        if (this.activeDirectoryProperties() != null) {
            this.activeDirectoryProperties().validate();
        }
    }
}

