/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.Bypass;
import com.azure.resourcemanager.storage.models.DefaultAction;
import com.azure.resourcemanager.storage.models.IpRule;
import com.azure.resourcemanager.storage.models.VirtualNetworkRule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkRuleSet {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NetworkRuleSet.class);
    @JsonProperty(value="bypass")
    private Bypass bypass;
    @JsonProperty(value="virtualNetworkRules")
    private List<VirtualNetworkRule> virtualNetworkRules;
    @JsonProperty(value="ipRules")
    private List<IpRule> ipRules;
    @JsonProperty(value="defaultAction", required=true)
    private DefaultAction defaultAction;

    public Bypass bypass() {
        return this.bypass;
    }

    public NetworkRuleSet withBypass(Bypass bypass) {
        this.bypass = bypass;
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public NetworkRuleSet withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    public NetworkRuleSet withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public DefaultAction defaultAction() {
        return this.defaultAction;
    }

    public NetworkRuleSet withDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public void validate() {
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.defaultAction() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property defaultAction in model NetworkRuleSet"));
        }
    }
}

