/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.EncryptionScopeKeyVaultProperties;
import com.azure.resourcemanager.storage.models.EncryptionScopeSource;
import com.azure.resourcemanager.storage.models.EncryptionScopeState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class EncryptionScopeProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EncryptionScopeProperties.class);
    @JsonProperty(value="source")
    private EncryptionScopeSource source;
    @JsonProperty(value="state")
    private EncryptionScopeState state;
    @JsonProperty(value="creationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationTime;
    @JsonProperty(value="lastModifiedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedTime;
    @JsonProperty(value="keyVaultProperties")
    private EncryptionScopeKeyVaultProperties keyVaultProperties;
    @JsonProperty(value="requireInfrastructureEncryption")
    private Boolean requireInfrastructureEncryption;

    public EncryptionScopeSource source() {
        return this.source;
    }

    public EncryptionScopeProperties withSource(EncryptionScopeSource source) {
        this.source = source;
        return this;
    }

    public EncryptionScopeState state() {
        return this.state;
    }

    public EncryptionScopeProperties withState(EncryptionScopeState state) {
        this.state = state;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public EncryptionScopeKeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public EncryptionScopeProperties withKeyVaultProperties(EncryptionScopeKeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public Boolean requireInfrastructureEncryption() {
        return this.requireInfrastructureEncryption;
    }

    public EncryptionScopeProperties withRequireInfrastructureEncryption(Boolean requireInfrastructureEncryption) {
        this.requireInfrastructureEncryption = requireInfrastructureEncryption;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
    }
}

