/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.models.ContainerProperties;
import com.azure.resourcemanager.storage.models.AzureEntityResource;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyProperties;
import com.azure.resourcemanager.storage.models.ImmutableStorageWithVersioning;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.LegalHoldProperties;
import com.azure.resourcemanager.storage.models.PublicAccess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class BlobContainerInner
extends AzureEntityResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BlobContainerInner.class);
    @JsonProperty(value="properties")
    private ContainerProperties innerContainerProperties;

    private ContainerProperties innerContainerProperties() {
        return this.innerContainerProperties;
    }

    public String version() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().version();
    }

    public Boolean deleted() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().deleted();
    }

    public OffsetDateTime deletedTime() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().deletedTime();
    }

    public Integer remainingRetentionDays() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().remainingRetentionDays();
    }

    public String defaultEncryptionScope() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().defaultEncryptionScope();
    }

    public BlobContainerInner withDefaultEncryptionScope(String defaultEncryptionScope) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withDefaultEncryptionScope(defaultEncryptionScope);
        return this;
    }

    public Boolean denyEncryptionScopeOverride() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().denyEncryptionScopeOverride();
    }

    public BlobContainerInner withDenyEncryptionScopeOverride(Boolean denyEncryptionScopeOverride) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withDenyEncryptionScopeOverride(denyEncryptionScopeOverride);
        return this;
    }

    public PublicAccess publicAccess() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().publicAccess();
    }

    public BlobContainerInner withPublicAccess(PublicAccess publicAccess) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withPublicAccess(publicAccess);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().lastModifiedTime();
    }

    public LeaseStatus leaseStatus() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().leaseStatus();
    }

    public LeaseState leaseState() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().leaseState();
    }

    public LeaseDuration leaseDuration() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().leaseDuration();
    }

    public Map<String, String> metadata() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().metadata();
    }

    public BlobContainerInner withMetadata(Map<String, String> metadata) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withMetadata(metadata);
        return this;
    }

    public ImmutabilityPolicyProperties immutabilityPolicy() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().immutabilityPolicy();
    }

    public LegalHoldProperties legalHold() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().legalHold();
    }

    public Boolean hasLegalHold() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().hasLegalHold();
    }

    public Boolean hasImmutabilityPolicy() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().hasImmutabilityPolicy();
    }

    public ImmutableStorageWithVersioning immutableStorageWithVersioning() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().immutableStorageWithVersioning();
    }

    public BlobContainerInner withImmutableStorageWithVersioning(ImmutableStorageWithVersioning immutableStorageWithVersioning) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withImmutableStorageWithVersioning(immutableStorageWithVersioning);
        return this;
    }

    public Boolean enableNfsV3RootSquash() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().enableNfsV3RootSquash();
    }

    public BlobContainerInner withEnableNfsV3RootSquash(Boolean enableNfsV3RootSquash) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withEnableNfsV3RootSquash(enableNfsV3RootSquash);
        return this;
    }

    public Boolean enableNfsV3AllSquash() {
        return this.innerContainerProperties() == null ? null : this.innerContainerProperties().enableNfsV3AllSquash();
    }

    public BlobContainerInner withEnableNfsV3AllSquash(Boolean enableNfsV3AllSquash) {
        if (this.innerContainerProperties() == null) {
            this.innerContainerProperties = new ContainerProperties();
        }
        this.innerContainerProperties().withEnableNfsV3AllSquash(enableNfsV3AllSquash);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerContainerProperties() != null) {
            this.innerContainerProperties().validate();
        }
    }
}

