/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.models.ContainerProperties;
import com.azure.resourcemanager.storage.models.AzureEntityResource;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyProperties;
import com.azure.resourcemanager.storage.models.ImmutableStorageWithVersioning;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.LegalHoldProperties;
import com.azure.resourcemanager.storage.models.PublicAccess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ListContainerItemInner
extends AzureEntityResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ListContainerItemInner.class);
    @JsonProperty(value="properties")
    private ContainerProperties innerProperties;

    private ContainerProperties innerProperties() {
        return this.innerProperties;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public Boolean deleted() {
        return this.innerProperties() == null ? null : this.innerProperties().deleted();
    }

    public OffsetDateTime deletedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().deletedTime();
    }

    public Integer remainingRetentionDays() {
        return this.innerProperties() == null ? null : this.innerProperties().remainingRetentionDays();
    }

    public String defaultEncryptionScope() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultEncryptionScope();
    }

    public ListContainerItemInner withDefaultEncryptionScope(String defaultEncryptionScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withDefaultEncryptionScope(defaultEncryptionScope);
        return this;
    }

    public Boolean denyEncryptionScopeOverride() {
        return this.innerProperties() == null ? null : this.innerProperties().denyEncryptionScopeOverride();
    }

    public ListContainerItemInner withDenyEncryptionScopeOverride(Boolean denyEncryptionScopeOverride) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withDenyEncryptionScopeOverride(denyEncryptionScopeOverride);
        return this;
    }

    public PublicAccess publicAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicAccess();
    }

    public ListContainerItemInner withPublicAccess(PublicAccess publicAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withPublicAccess(publicAccess);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public LeaseStatus leaseStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().leaseStatus();
    }

    public LeaseState leaseState() {
        return this.innerProperties() == null ? null : this.innerProperties().leaseState();
    }

    public LeaseDuration leaseDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().leaseDuration();
    }

    public Map<String, String> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public ListContainerItemInner withMetadata(Map<String, String> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public ImmutabilityPolicyProperties immutabilityPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().immutabilityPolicy();
    }

    public LegalHoldProperties legalHold() {
        return this.innerProperties() == null ? null : this.innerProperties().legalHold();
    }

    public Boolean hasLegalHold() {
        return this.innerProperties() == null ? null : this.innerProperties().hasLegalHold();
    }

    public Boolean hasImmutabilityPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().hasImmutabilityPolicy();
    }

    public ImmutableStorageWithVersioning immutableStorageWithVersioning() {
        return this.innerProperties() == null ? null : this.innerProperties().immutableStorageWithVersioning();
    }

    public ListContainerItemInner withImmutableStorageWithVersioning(ImmutableStorageWithVersioning immutableStorageWithVersioning) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withImmutableStorageWithVersioning(immutableStorageWithVersioning);
        return this;
    }

    public Boolean enableNfsV3RootSquash() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNfsV3RootSquash();
    }

    public ListContainerItemInner withEnableNfsV3RootSquash(Boolean enableNfsV3RootSquash) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withEnableNfsV3RootSquash(enableNfsV3RootSquash);
        return this;
    }

    public Boolean enableNfsV3AllSquash() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNfsV3AllSquash();
    }

    public ListContainerItemInner withEnableNfsV3AllSquash(Boolean enableNfsV3AllSquash) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withEnableNfsV3AllSquash(enableNfsV3AllSquash);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

