/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.models.LocalUserProperties;
import com.azure.resourcemanager.storage.models.PermissionScope;
import com.azure.resourcemanager.storage.models.SshPublicKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class LocalUserInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LocalUserInner.class);
    @JsonProperty(value="properties")
    private LocalUserProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    private LocalUserProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public List<PermissionScope> permissionScopes() {
        return this.innerProperties() == null ? null : this.innerProperties().permissionScopes();
    }

    public LocalUserInner withPermissionScopes(List<PermissionScope> permissionScopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalUserProperties();
        }
        this.innerProperties().withPermissionScopes(permissionScopes);
        return this;
    }

    public String homeDirectory() {
        return this.innerProperties() == null ? null : this.innerProperties().homeDirectory();
    }

    public LocalUserInner withHomeDirectory(String homeDirectory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalUserProperties();
        }
        this.innerProperties().withHomeDirectory(homeDirectory);
        return this;
    }

    public List<SshPublicKey> sshAuthorizedKeys() {
        return this.innerProperties() == null ? null : this.innerProperties().sshAuthorizedKeys();
    }

    public LocalUserInner withSshAuthorizedKeys(List<SshPublicKey> sshAuthorizedKeys) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalUserProperties();
        }
        this.innerProperties().withSshAuthorizedKeys(sshAuthorizedKeys);
        return this;
    }

    public String sid() {
        return this.innerProperties() == null ? null : this.innerProperties().sid();
    }

    public Boolean hasSharedKey() {
        return this.innerProperties() == null ? null : this.innerProperties().hasSharedKey();
    }

    public LocalUserInner withHasSharedKey(Boolean hasSharedKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalUserProperties();
        }
        this.innerProperties().withHasSharedKey(hasSharedKey);
        return this;
    }

    public Boolean hasSshKey() {
        return this.innerProperties() == null ? null : this.innerProperties().hasSshKey();
    }

    public LocalUserInner withHasSshKey(Boolean hasSshKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalUserProperties();
        }
        this.innerProperties().withHasSshKey(hasSshKey);
        return this;
    }

    public Boolean hasSshPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().hasSshPassword();
    }

    public LocalUserInner withHasSshPassword(Boolean hasSshPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LocalUserProperties();
        }
        this.innerProperties().withHasSshPassword(hasSshPassword);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

