/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.models.ImmutabilityPolicyProperty;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyState;
import com.azure.resourcemanager.storage.models.UpdateHistoryProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ImmutabilityPolicyProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImmutabilityPolicyProperties.class);
    @JsonProperty(value="properties")
    private ImmutabilityPolicyProperty innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="updateHistory", access=JsonProperty.Access.WRITE_ONLY)
    private List<UpdateHistoryProperty> updateHistory;

    private ImmutabilityPolicyProperty innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public List<UpdateHistoryProperty> updateHistory() {
        return this.updateHistory;
    }

    public Integer immutabilityPeriodSinceCreationInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().immutabilityPeriodSinceCreationInDays();
    }

    public ImmutabilityPolicyProperties withImmutabilityPeriodSinceCreationInDays(Integer immutabilityPeriodSinceCreationInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImmutabilityPolicyProperty();
        }
        this.innerProperties().withImmutabilityPeriodSinceCreationInDays(immutabilityPeriodSinceCreationInDays);
        return this;
    }

    public ImmutabilityPolicyState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public Boolean allowProtectedAppendWrites() {
        return this.innerProperties() == null ? null : this.innerProperties().allowProtectedAppendWrites();
    }

    public ImmutabilityPolicyProperties withAllowProtectedAppendWrites(Boolean allowProtectedAppendWrites) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImmutabilityPolicyProperty();
        }
        this.innerProperties().withAllowProtectedAppendWrites(allowProtectedAppendWrites);
        return this;
    }

    public Boolean allowProtectedAppendWritesAll() {
        return this.innerProperties() == null ? null : this.innerProperties().allowProtectedAppendWritesAll();
    }

    public ImmutabilityPolicyProperties withAllowProtectedAppendWritesAll(Boolean allowProtectedAppendWritesAll) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImmutabilityPolicyProperty();
        }
        this.innerProperties().withAllowProtectedAppendWritesAll(allowProtectedAppendWritesAll);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.updateHistory() != null) {
            this.updateHistory().forEach(e -> e.validate());
        }
    }
}

