// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The AccessPolicy model. */
@Fluent
public final class AccessPolicy {
    /*
     * Start time of the access policy
     */
    @JsonProperty(value = "startTime")
    private OffsetDateTime startTime;

    /*
     * Expiry time of the access policy
     */
    @JsonProperty(value = "expiryTime")
    private OffsetDateTime expiryTime;

    /*
     * List of abbreviated permissions.
     */
    @JsonProperty(value = "permission")
    private String permission;

    /**
     * Get the startTime property: Start time of the access policy.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time of the access policy.
     *
     * @param startTime the startTime value to set.
     * @return the AccessPolicy object itself.
     */
    public AccessPolicy withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the expiryTime property: Expiry time of the access policy.
     *
     * @return the expiryTime value.
     */
    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    /**
     * Set the expiryTime property: Expiry time of the access policy.
     *
     * @param expiryTime the expiryTime value to set.
     * @return the AccessPolicy object itself.
     */
    public AccessPolicy withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    /**
     * Get the permission property: List of abbreviated permissions.
     *
     * @return the permission value.
     */
    public String permission() {
        return this.permission;
    }

    /**
     * Set the permission property: List of abbreviated permissions.
     *
     * @param permission the permission value to set.
     * @return the AccessPolicy object itself.
     */
    public AccessPolicy withPermission(String permission) {
        this.permission = permission;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
