// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ActiveDirectoryPropertiesAccountType. */
public final class ActiveDirectoryPropertiesAccountType
    extends ExpandableStringEnum<ActiveDirectoryPropertiesAccountType> {
    /** Static value User for ActiveDirectoryPropertiesAccountType. */
    public static final ActiveDirectoryPropertiesAccountType USER = fromString("User");

    /** Static value Computer for ActiveDirectoryPropertiesAccountType. */
    public static final ActiveDirectoryPropertiesAccountType COMPUTER = fromString("Computer");

    /**
     * Creates or finds a ActiveDirectoryPropertiesAccountType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ActiveDirectoryPropertiesAccountType.
     */
    @JsonCreator
    public static ActiveDirectoryPropertiesAccountType fromString(String name) {
        return fromString(name, ActiveDirectoryPropertiesAccountType.class);
    }

    /** @return known ActiveDirectoryPropertiesAccountType values. */
    public static Collection<ActiveDirectoryPropertiesAccountType> values() {
        return values(ActiveDirectoryPropertiesAccountType.class);
    }
}
