// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Name of the policy. The valid value is AccessTimeTracking. This field is currently read only. */
public final class Name extends ExpandableStringEnum<Name> {
    /** Static value AccessTimeTracking for Name. */
    public static final Name ACCESS_TIME_TRACKING = fromString("AccessTimeTracking");

    /**
     * Creates or finds a Name from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding Name.
     */
    @JsonCreator
    public static Name fromString(String name) {
        return fromString(name, Name.class);
    }

    /**
     * Gets known Name values.
     *
     * @return known Name values.
     */
    public static Collection<Name> values() {
        return values(Name.class);
    }
}
