// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
 */
@Immutable
public final class SkuCapability {
    /*
     * The name of capability, The capability information in the specified SKU, including file encryption, network
     * ACLs, change notification, etc.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * A string value to indicate states of given capability. Possibly 'true' or 'false'.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private String value;

    /** Creates an instance of SkuCapability class. */
    public SkuCapability() {
    }

    /**
     * Get the name property: The name of capability, The capability information in the specified SKU, including file
     * encryption, network ACLs, change notification, etc.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the value property: A string value to indicate states of given capability. Possibly 'true' or 'false'.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
