// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * An object that defines the blob inventory rule filter conditions. For 'Blob' definition.objectType all filter
 * properties are applicable, 'blobTypes' is required and others are optional. For 'Container' definition.objectType
 * only prefixMatch is applicable and is optional.
 */
@Fluent
public final class BlobInventoryPolicyFilter {
    /*
     * An array of strings with maximum 10 blob prefixes to be included in the inventory.
     */
    @JsonProperty(value = "prefixMatch")
    private List<String> prefixMatch;

    /*
     * An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
     */
    @JsonProperty(value = "excludePrefix")
    private List<String> excludePrefix;

    /*
     * An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not
     * support pageBlobs. This field is required when definition.objectType property is set to 'Blob'.
     */
    @JsonProperty(value = "blobTypes")
    private List<String> blobTypes;

    /*
     * Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values
     * 'VersionId and IsCurrentVersion' are required if this property is set to true, else they must be excluded.
     */
    @JsonProperty(value = "includeBlobVersions")
    private Boolean includeBlobVersions;

    /*
     * Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value
     * 'Snapshot' is required if this property is set to true, else it must be excluded.
     */
    @JsonProperty(value = "includeSnapshots")
    private Boolean includeSnapshots;

    /*
     * For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime
     * and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled storage accounts the
     * definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns
     * disabled accounts the definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be
     * excluded.
     */
    @JsonProperty(value = "includeDeleted")
    private Boolean includeDeleted;

    /*
     * This property is used to filter objects based on the object creation time
     */
    @JsonProperty(value = "creationTime")
    private BlobInventoryCreationTime creationTime;

    /** Creates an instance of BlobInventoryPolicyFilter class. */
    public BlobInventoryPolicyFilter() {
    }

    /**
     * Get the prefixMatch property: An array of strings with maximum 10 blob prefixes to be included in the inventory.
     *
     * @return the prefixMatch value.
     */
    public List<String> prefixMatch() {
        return this.prefixMatch;
    }

    /**
     * Set the prefixMatch property: An array of strings with maximum 10 blob prefixes to be included in the inventory.
     *
     * @param prefixMatch the prefixMatch value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withPrefixMatch(List<String> prefixMatch) {
        this.prefixMatch = prefixMatch;
        return this;
    }

    /**
     * Get the excludePrefix property: An array of strings with maximum 10 blob prefixes to be excluded from the
     * inventory.
     *
     * @return the excludePrefix value.
     */
    public List<String> excludePrefix() {
        return this.excludePrefix;
    }

    /**
     * Set the excludePrefix property: An array of strings with maximum 10 blob prefixes to be excluded from the
     * inventory.
     *
     * @param excludePrefix the excludePrefix value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withExcludePrefix(List<String> excludePrefix) {
        this.excludePrefix = excludePrefix;
        return this;
    }

    /**
     * Get the blobTypes property: An array of predefined enum values. Valid values include blockBlob, appendBlob,
     * pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is
     * set to 'Blob'.
     *
     * @return the blobTypes value.
     */
    public List<String> blobTypes() {
        return this.blobTypes;
    }

    /**
     * Set the blobTypes property: An array of predefined enum values. Valid values include blockBlob, appendBlob,
     * pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is
     * set to 'Blob'.
     *
     * @param blobTypes the blobTypes value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withBlobTypes(List<String> blobTypes) {
        this.blobTypes = blobTypes;
        return this;
    }

    /**
     * Get the includeBlobVersions property: Includes blob versions in blob inventory when value is set to true. The
     * definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true,
     * else they must be excluded.
     *
     * @return the includeBlobVersions value.
     */
    public Boolean includeBlobVersions() {
        return this.includeBlobVersions;
    }

    /**
     * Set the includeBlobVersions property: Includes blob versions in blob inventory when value is set to true. The
     * definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true,
     * else they must be excluded.
     *
     * @param includeBlobVersions the includeBlobVersions value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withIncludeBlobVersions(Boolean includeBlobVersions) {
        this.includeBlobVersions = includeBlobVersions;
        return this;
    }

    /**
     * Get the includeSnapshots property: Includes blob snapshots in blob inventory when value is set to true. The
     * definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded.
     *
     * @return the includeSnapshots value.
     */
    public Boolean includeSnapshots() {
        return this.includeSnapshots;
    }

    /**
     * Set the includeSnapshots property: Includes blob snapshots in blob inventory when value is set to true. The
     * definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded.
     *
     * @param includeSnapshots the includeSnapshots value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withIncludeSnapshots(Boolean includeSnapshots) {
        this.includeSnapshots = includeSnapshots;
        return this;
    }

    /**
     * Get the includeDeleted property: For 'Container' definition.objectType the definition.schemaFields must include
     * 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled
     * storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and
     * RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and
     * RemainingRetentionDays', else it must be excluded.
     *
     * @return the includeDeleted value.
     */
    public Boolean includeDeleted() {
        return this.includeDeleted;
    }

    /**
     * Set the includeDeleted property: For 'Container' definition.objectType the definition.schemaFields must include
     * 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled
     * storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and
     * RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and
     * RemainingRetentionDays', else it must be excluded.
     *
     * @param includeDeleted the includeDeleted value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
    }

    /**
     * Get the creationTime property: This property is used to filter objects based on the object creation time.
     *
     * @return the creationTime value.
     */
    public BlobInventoryCreationTime creationTime() {
        return this.creationTime;
    }

    /**
     * Set the creationTime property: This property is used to filter objects based on the object creation time.
     *
     * @param creationTime the creationTime value to set.
     * @return the BlobInventoryPolicyFilter object itself.
     */
    public BlobInventoryPolicyFilter withCreationTime(BlobInventoryCreationTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (creationTime() != null) {
            creationTime().validate();
        }
    }
}
