// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped
 * encryption key will be used. 'Service' key type implies that a default service key is used.
 */
public final class KeyType extends ExpandableStringEnum<KeyType> {
    /** Static value Service for KeyType. */
    public static final KeyType SERVICE = fromString("Service");

    /** Static value Account for KeyType. */
    public static final KeyType ACCOUNT = fromString("Account");

    /**
     * Creates a new instance of KeyType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public KeyType() {
    }

    /**
     * Creates or finds a KeyType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding KeyType.
     */
    @JsonCreator
    public static KeyType fromString(String name) {
        return fromString(name, KeyType.class);
    }

    /**
     * Gets known KeyType values.
     *
     * @return known KeyType values.
     */
    public static Collection<KeyType> values() {
        return values(KeyType.class);
    }
}
