// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The blob service properties for Last access time based tracking policy. */
@Fluent
public final class LastAccessTimeTrackingPolicy {
    /*
     * When set to true last access time based tracking is enabled.
     */
    @JsonProperty(value = "enable", required = true)
    private boolean enable;

    /*
     * Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
     */
    @JsonProperty(value = "name")
    private Name name;

    /*
     * The field specifies blob object tracking granularity in days, typically how often the blob object should be
     * tracked.This field is currently read only with value as 1
     */
    @JsonProperty(value = "trackingGranularityInDays")
    private Integer trackingGranularityInDays;

    /*
     * An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read
     * only
     */
    @JsonProperty(value = "blobType")
    private List<String> blobType;

    /** Creates an instance of LastAccessTimeTrackingPolicy class. */
    public LastAccessTimeTrackingPolicy() {
    }

    /**
     * Get the enable property: When set to true last access time based tracking is enabled.
     *
     * @return the enable value.
     */
    public boolean enable() {
        return this.enable;
    }

    /**
     * Set the enable property: When set to true last access time based tracking is enabled.
     *
     * @param enable the enable value to set.
     * @return the LastAccessTimeTrackingPolicy object itself.
     */
    public LastAccessTimeTrackingPolicy withEnable(boolean enable) {
        this.enable = enable;
        return this;
    }

    /**
     * Get the name property: Name of the policy. The valid value is AccessTimeTracking. This field is currently read
     * only.
     *
     * @return the name value.
     */
    public Name name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the policy. The valid value is AccessTimeTracking. This field is currently read
     * only.
     *
     * @param name the name value to set.
     * @return the LastAccessTimeTrackingPolicy object itself.
     */
    public LastAccessTimeTrackingPolicy withName(Name name) {
        this.name = name;
        return this;
    }

    /**
     * Get the trackingGranularityInDays property: The field specifies blob object tracking granularity in days,
     * typically how often the blob object should be tracked.This field is currently read only with value as 1.
     *
     * @return the trackingGranularityInDays value.
     */
    public Integer trackingGranularityInDays() {
        return this.trackingGranularityInDays;
    }

    /**
     * Set the trackingGranularityInDays property: The field specifies blob object tracking granularity in days,
     * typically how often the blob object should be tracked.This field is currently read only with value as 1.
     *
     * @param trackingGranularityInDays the trackingGranularityInDays value to set.
     * @return the LastAccessTimeTrackingPolicy object itself.
     */
    public LastAccessTimeTrackingPolicy withTrackingGranularityInDays(Integer trackingGranularityInDays) {
        this.trackingGranularityInDays = trackingGranularityInDays;
        return this;
    }

    /**
     * Get the blobType property: An array of predefined supported blob types. Only blockBlob is the supported value.
     * This field is currently read only.
     *
     * @return the blobType value.
     */
    public List<String> blobType() {
        return this.blobType;
    }

    /**
     * Set the blobType property: An array of predefined supported blob types. Only blockBlob is the supported value.
     * This field is currently read only.
     *
     * @param blobType the blobType value to set.
     * @return the LastAccessTimeTrackingPolicy object itself.
     */
    public LastAccessTimeTrackingPolicy withBlobType(List<String> blobType) {
        this.blobType = blobType;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
