/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.MigrationStatus;
import com.azure.resourcemanager.storage.models.SkuName;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class StorageAccountMigrationProperties {
    @JsonProperty(value="targetSkuName", required=true)
    private SkuName targetSkuName;
    @JsonProperty(value="migrationStatus", access=JsonProperty.Access.WRITE_ONLY)
    private MigrationStatus migrationStatus;
    @JsonProperty(value="migrationFailedReason", access=JsonProperty.Access.WRITE_ONLY)
    private String migrationFailedReason;
    @JsonProperty(value="migrationFailedDetailedReason", access=JsonProperty.Access.WRITE_ONLY)
    private String migrationFailedDetailedReason;
    private static final ClientLogger LOGGER = new ClientLogger(StorageAccountMigrationProperties.class);

    public SkuName targetSkuName() {
        return this.targetSkuName;
    }

    public StorageAccountMigrationProperties withTargetSkuName(SkuName targetSkuName) {
        this.targetSkuName = targetSkuName;
        return this;
    }

    public MigrationStatus migrationStatus() {
        return this.migrationStatus;
    }

    public String migrationFailedReason() {
        return this.migrationFailedReason;
    }

    public String migrationFailedDetailedReason() {
        return this.migrationFailedDetailedReason;
    }

    public void validate() {
        if (this.targetSkuName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property targetSkuName in model StorageAccountMigrationProperties"));
        }
    }
}

